"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classNameChangeTest = exports.Skeleton = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _SelectItemGroup = _interopRequireDefault(require("../SelectItemGroup"));

var _Select2 = _interopRequireDefault(require("../Select/Select.Skeleton"));

var _Select3 = _interopRequireDefault(require("./Select.mdx"));

var _FeatureFlags = require("../FeatureFlags");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  select: function select() {
    return {
      className: 'some-class',
      light: (0, _addonKnobs.boolean)('Light variant (light in <Select>)', false),
      inline: (0, _addonKnobs.boolean)('Put control in-line with label (inline in <Select>)', false),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <Select>)', false),
      hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel in <Select>)', false),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid in <Select>)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText in <Select>)', 'A valid value is required'),
      labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Select'),
      helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
      onChange: (0, _addonActions.action)('onChange'),
      warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
      warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This will overwrite your current settings')
    };
  },
  group: function group() {
    return {
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <SelectItemGroup>)', false)
    };
  }
};
var _default = {
  title: 'Components/Select',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Select.default,
    docs: {
      page: _Select3.default
    },
    subcomponents: {
      SelectItem: _SelectItem.default,
      SelectItemGroup: _SelectItemGroup.default,
      SelectSkeleton: _Select2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  var groupProps = props.group();
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Select.default, (0, _extends2.default)({}, props.select(), {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, (0, _extends2.default)({
    label: "Category 1"
  }, groupProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, (0, _extends2.default)({
    label: "Category 2"
  }, groupProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  }))));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Select displays a list below its title when selected. They are used primarily in forms,\n        where a user chooses one option from a list. Once the user selects an item, the dropdown will\n        disappear and the field will reflect the user's choice. Create Select Item components for each\n        option in the list. The example below shows an enabled Select component with three items.\n      "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    },
    "aria-label": "loading select",
    "aria-live": "assertive",
    role: "status",
    tabIndex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, /*#__PURE__*/_react.default.createElement(_Select2.default, null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};

var classNameChangeTest = function classNameChangeTest() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Select.default, {
    className: "TEST_CLASS",
    id: "select-1",
    defaultValue: "placeholder-item"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "The class should be added to the label"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 1"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 2"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  }))), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement(_Select.default, {
    className: "TEST_CLASS",
    id: "select-1",
    defaultValue: "placeholder-item"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "The class should be added to the wrapper"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 1"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 2"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  })))));
};

exports.classNameChangeTest = classNameChangeTest;