"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expandable = exports.Skeleton = exports.DeprecatedCustomButtons = exports.SizeStory = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Search = _interopRequireDefault(require("../Search"));

var _Search2 = _interopRequireDefault(require("../Search/Search.Skeleton"));

var _SearchFilterButton = _interopRequireDefault(require("../SearchFilterButton"));

var _SearchLayoutButton = _interopRequireDefault(require("../SearchLayoutButton"));

var _ExpandableSearch = _interopRequireDefault(require("../ExpandableSearch"));

var _Search3 = _interopRequireDefault(require("./Search.mdx"));

var _FeatureFlags = require("../FeatureFlags");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
// V11: Updated Size Table
// const sizes = {
//   'Small (sm)': 'sm',
//   'Medium (md)': 'md',
//   'Large (lg) - default': 'lg',
// };
var sizes = {
  'Small (sm)': 'sm',
  'Large (lg)': 'lg',
  'Extra Large (xl) - default': 'xl'
};

var props = function props() {
  return {
    className: 'some-class',
    size: (0, _addonKnobs.select)('Size (size)', sizes, 'xl'),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    name: (0, _addonKnobs.text)('Form item name (name)', ''),
    defaultValue: (0, _addonKnobs.text)('Default value (defaultValue)', ''),
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Search'),
    closeButtonLabelText: (0, _addonKnobs.text)('The label text for the close button (closeButtonLabelText)', 'Clear search input'),
    placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder)', 'Search'),
    onChange: (0, _addonActions.action)('onChange'),
    onKeyDown: (0, _addonActions.action)('onKeyDown'),
    onClear: (0, _addonActions.action)('onClear')
  };
};

var _default = {
  title: 'Components/Search',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Search.default,
    docs: {
      page: _Search3.default
    },
    subcomponents: {
      SearchSkeleton: _Search2.default,
      SearchFilterButton: _SearchFilterButton.default,
      SearchLayoutButton: _SearchLayoutButton.default,
      ExpandableSearch: _ExpandableSearch.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Search.default, (0, _extends2.default)({}, props(), {
    id: "search-1"
  }));
};

exports.Default = Default;

var SizeStory = function SizeStory() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h3", null, "Feature Flags: DISABLED"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "sm",
    size: "sm",
    id: "search-1"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "lg",
    size: "lg",
    id: "search-1"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "xl",
    size: "xl",
    id: "search-1"
  }), /*#__PURE__*/_react.default.createElement("br", null)), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Feature Flags: ENABLED"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "sm",
    size: "sm",
    id: "search-4"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "md",
    size: "md",
    id: "search-5"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Search.default, {
    placeholder: "lg",
    size: "lg",
    id: "search-6"
  })));
};

exports.SizeStory = SizeStory;
Default.parameters = {
  info: {
    text: "\n            Search enables users to specify a word or a phrase to find particular relevant pieces of content\n            without the use of navigation. Search can be used as the primary means of discovering content,\n            or as a filter to aid the user in finding content.\n          "
  }
};

var DeprecatedCustomButtons = function DeprecatedCustomButtons() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_Search.default, (0, _extends2.default)({}, props(), {
    id: "search-1"
  })), /*#__PURE__*/_react.default.createElement(_SearchFilterButton.default, {
    onClick: (0, _addonActions.action)('onClick')
  }), /*#__PURE__*/_react.default.createElement(_SearchLayoutButton.default, {
    onClick: (0, _addonActions.action)('onClick')
  }));
};

exports.DeprecatedCustomButtons = DeprecatedCustomButtons;
DeprecatedCustomButtons.storyName = '[Deprecated] custom buttons';
DeprecatedCustomButtons.parameters = {
  info: {
    text: "\n        You can control what set of buttons you want.\n      "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_Search2.default, null), "\xA0", /*#__PURE__*/_react.default.createElement(_Search2.default, {
    small: true
  }));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};

var Expandable = function Expandable() {
  return /*#__PURE__*/_react.default.createElement(_ExpandableSearch.default, (0, _extends2.default)({}, props(), {
    id: "search-expandable-1"
  }));
};

exports.Expandable = Expandable;
Expandable.storyName = 'Expandable';