"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _keyboard = require("../../internal/keyboard");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["children", "className", "disabled", "iconDescription", "light", "checked", "name", "value", "id", "onChange", "tabIndex"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

function RadioTile(_ref) {
  var _classNames;

  var children = _ref.children,
      className = _ref.className,
      disabled = _ref.disabled,
      iconDescription = _ref.iconDescription,
      light = _ref.light,
      checked = _ref.checked,
      name = _ref.name,
      value = _ref.value,
      id = _ref.id,
      onChange = _ref.onChange,
      tabIndex = _ref.tabIndex,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useRef = (0, _react.useRef)(id || (0, _uniqueId.default)()),
      inputId = _useRef.current;

  var classes = (0, _classnames.default)(className, "".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tile--is-selected"), checked), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tile--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tile--disabled"), disabled), _classNames));

  function handleOnChange(evt) {
    onChange(value, name, evt);
  }

  function handleOnKeyDown(evt) {
    if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      evt.preventDefault();
      onChange(value, name, evt);
    }
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, {
    type: "radio",
    checked: checked,
    disabled: disabled,
    name: name,
    value: value,
    className: "".concat(prefix, "--tile-input"),
    tabIndex: !disabled ? tabIndex : null,
    onChange: !disabled ? handleOnChange : null,
    onKeyDown: !disabled ? handleOnKeyDown : null,
    id: inputId
  })), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: inputId,
    className: classes
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark")
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, null)), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
}

RadioTile.propTypes = {
  /**
   * `true` if this tile should be selected.
   */
  checked: _propTypes.default.bool,

  /**
   * The tile content.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the `<input>` should be checked at initialization.
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify whether the RadioTile should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * The description of the tile checkmark icon.
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop for `RadioTile` is no longer needed and has ' + 'been deprecated. It will be moved in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * The `name` of the `<input>`.
   */
  name: _propTypes.default.string,

  /**
   * The handler of the massaged `change` event on the `<input>`.
   */
  onChange: _propTypes.default.func,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: _propTypes.default.number,

  /**
   * The `value` of the `<input>`.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
};
RadioTile.defaultProps = {
  onChange: function onChange() {},
  tabIndex: 0,
  light: false
};
var _default = RadioTile;
exports.default = _default;