"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = require("@testing-library/react");

var _react2 = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _RadioButtonGroup = _interopRequireDefault(require("../RadioButtonGroup"));

var _RadioButton = _interopRequireDefault(require("../../RadioButton/next/RadioButton"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('RadioButtonGroup', function () {
  it('should render `legendText` in a <label>', function () {
    (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
      defaultSelected: "test-1",
      name: "test",
      legendText: "test"
    }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-1",
      value: "test-1"
    }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-2",
      value: "test-2"
    })));

    var legend = _react.screen.getByText('test', {
      selector: 'legend'
    });

    expect(legend).toBeDefined();
  });
  it('should render `legendText` in a <fieldset>', function () {
    (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
      defaultSelected: "test-1",
      name: "test",
      legendText: "test"
    }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-1",
      value: "test-1"
    }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-2",
      value: "test-2"
    })));

    var fieldset = _react.screen.getByText('test', {
      selector: 'legend'
    }).closest('fieldset');

    expect(fieldset).toBeDefined();
  });
  it('should render <RadioButton> as children', function () {
    (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
      defaultSelected: "test-1",
      name: "test",
      legendText: "test"
    }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-1",
      value: "test-1"
    }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
      labelText: "test-2",
      value: "test-2"
    })));

    var fieldset = _react.screen.getByText('test', {
      selector: 'legend'
    }).closest('fieldset');

    expect(fieldset).toContainElement(_react.screen.getByLabelText('test-1'));
    expect(fieldset).toContainElement(_react.screen.getByLabelText('test-2'));
  });
  describe('Component API', function () {
    it('should support a custom className on the <fieldset>', function () {
      (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        className: "custom-class",
        defaultSelected: "test-1",
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: "test-1"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-2",
        value: "test-2"
      })));

      var fieldset = _react.screen.getByText('test', {
        selector: 'legend'
      }).closest('fieldset');

      expect(fieldset).toHaveClass('custom-class');
    });
    it('should support passing in disabled to disable the <fieldset>', function () {
      (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        defaultSelected: "test-1",
        disabled: true,
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: "test-1"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-2",
        value: "test-2"
      })));

      var fieldset = _react.screen.getByText('test', {
        selector: 'legend'
      }).closest('fieldset');

      expect(fieldset).toBeDisabled();
    });
    it('should support `defaultSelected` as a way to select a radio button', function () {
      (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        defaultSelected: "test-1",
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: "test-1"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-2",
        value: "test-2"
      })));
      expect(_react.screen.getByLabelText('test-1')).toEqual(_react.screen.getByRole('radio', {
        checked: true
      }));
    });
    it('should support `valueSelected` as a way to select a radio button', function () {
      var _render = (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        valueSelected: "test-1",
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: "test-1"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-2",
        value: "test-2"
      }))),
          rerender = _render.rerender;

      expect(_react.screen.getByLabelText('test-1')).toEqual(_react.screen.getByRole('radio', {
        checked: true
      }));
      rerender( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        valueSelected: "test-2",
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: "test-1"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-2",
        value: "test-2"
      })));
      expect(_react.screen.getByLabelText('test-2')).toEqual(_react.screen.getByRole('radio', {
        checked: true
      }));
    });
    it('should support a 0 value for `valueSelected` (#9041)', function () {
      (0, _react.render)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        valueSelected: 0,
        name: "test",
        legendText: "test"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-1",
        value: 1
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "test-0",
        value: 0
      })));
      expect(_react.screen.getByLabelText('test-0')).toEqual(_react.screen.getByRole('radio', {
        checked: true
      }));
    });
    describe('onChange event', function () {
      var onChange = jest.fn();
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        onChange: onChange,
        name: "gender"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "Male",
        value: "male"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "Female",
        value: "female"
      })));
      var firstRadio = wrapper.find(_RadioButton.default).first();
      var args = ['male', 'gender', {
        test: 'test event'
      }];
      it('first child should not have checked set initially', function () {
        expect(firstRadio.props().checked).toEqual(false);
      });
      it('invoking onChange sets checked on correct child', function () {
        var _firstRadio$props;

        (_firstRadio$props = firstRadio.props()).onChange.apply(_firstRadio$props, args);

        wrapper.update();
        expect(wrapper.find(_RadioButton.default).first().props().checked).toEqual(true);
      });
      it('should invoke onChange with correct arguments', function () {
        var _expect;

        (_expect = expect(onChange)).toHaveBeenCalledWith.apply(_expect, args);
      });
      it('calling onChange with same args should not call onChange prop', function () {
        var _firstRadio$props2;

        onChange.mockClear();

        (_firstRadio$props2 = firstRadio.props()).onChange.apply(_firstRadio$props2, args);

        expect(onChange).not.toHaveBeenCalled();
      });
    });
    describe('Getting derived state from props', function () {
      var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react2.default.createElement(_RadioButtonGroup.default, {
        valueSelected: "male",
        defaultSelected: "female",
        name: "gender"
      }, /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "Male",
        value: "male"
      }), /*#__PURE__*/_react2.default.createElement(_RadioButton.default, {
        labelText: "Female",
        value: "female"
      })));
      it('should initialize the current selection from props', function () {
        expect(wrapper.state().selected).toEqual('male');
      });
      it('should change the current selection upon change in props', function () {
        wrapper.setProps({
          valueSelected: 'male'
        });
        wrapper.setState({
          selected: 'male'
        });
        wrapper.setProps({
          valueSelected: undefined
        });
        expect(wrapper.state().selected).toEqual('female');
      });
      it('should avoid change the current selection upon setting props, unless there the value actually changes', function () {
        wrapper.setProps({
          valueSelected: 'female'
        });
        wrapper.setState({
          selected: 'male'
        });
        wrapper.setProps({
          valueSelected: 'female'
        });
        expect(wrapper.state().selected).toEqual('male');
      });
    });
  });
});