"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className"];

function Step() {
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--progress-step ").concat(prefix, "--progress-step--incomplete")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--progress-step-button ").concat(prefix, "--progress-step-button--unclickable")
  }, /*#__PURE__*/_react.default.createElement("svg", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M 7, 7 m -7, 0 a 7,7 0 1,0 14,0 a 7,7 0 1,0 -14,0"
  })), /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--progress-label")
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--progress-line")
  })));
}

function ProgressIndicatorSkeleton(_ref) {
  var className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
    className: (0, _classnames.default)("".concat(prefix, "--progress"), "".concat(prefix, "--skeleton"), className)
  }, rest), /*#__PURE__*/_react.default.createElement(Step, null), /*#__PURE__*/_react.default.createElement(Step, null), /*#__PURE__*/_react.default.createElement(Step, null), /*#__PURE__*/_react.default.createElement(Step, null));
}

ProgressIndicatorSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string
};
var _default = ProgressIndicatorSkeleton;
exports.default = _default;