"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof3 = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Button = _interopRequireDefault(require("../../Button"));

var _Select = _interopRequireDefault(require("../../Select"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _array = require("../../../tools/array");

var _useId = require("../../../internal/useId");

var _usePrefix = require("../../../internal/usePrefix");

var _excluded = ["backwardText", "className", "disabled", "forwardText", "id", "isLastPage", "itemText", "itemRangeText", "itemsPerPageText", "onChange", "pageNumberText", "pageRangeText", "page", "pageInputDisabled", "pageSize", "pageSizeInputDisabled", "pageSizes", "pageText", "pagesUnknown", "size", "totalItems"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function mapPageSizesToObject(sizes) {
  return (0, _typeof2.default)(sizes[0]) === 'object' && sizes[0] !== null ? sizes : sizes.map(function (size) {
    return {
      text: size,
      value: size
    };
  });
}

function renderSelectItems(total) {
  var counter = 1;
  var itemArr = [];

  while (counter <= total) {
    itemArr.push( /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      key: counter,
      value: counter,
      text: String(counter)
    }));
    counter++;
  }

  return itemArr;
}

function getPageSize(pageSizes, pageSize) {
  if (pageSize) {
    var hasSize = pageSizes.find(function (size) {
      return pageSize === size.value;
    });

    if (hasSize) {
      return pageSize;
    }
  }

  return pageSizes[0].value;
}

function Pagination(_ref) {
  var _cx, _cx2, _cx3;

  var _ref$backwardText = _ref.backwardText,
      backwardText = _ref$backwardText === void 0 ? 'Previous page' : _ref$backwardText,
      customClassName = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$forwardText = _ref.forwardText,
      forwardText = _ref$forwardText === void 0 ? 'Next page' : _ref$forwardText,
      id = _ref.id,
      _ref$isLastPage = _ref.isLastPage,
      isLastPage = _ref$isLastPage === void 0 ? false : _ref$isLastPage,
      _ref$itemText = _ref.itemText,
      itemText = _ref$itemText === void 0 ? function (min, max) {
    return "".concat(min, "\u2013").concat(max, " items");
  } : _ref$itemText,
      _ref$itemRangeText = _ref.itemRangeText,
      itemRangeText = _ref$itemRangeText === void 0 ? function (min, max, total) {
    return "".concat(min, "\u2013").concat(max, " of ").concat(total, " items");
  } : _ref$itemRangeText,
      _ref$itemsPerPageText = _ref.itemsPerPageText,
      itemsPerPageText = _ref$itemsPerPageText === void 0 ? 'Items per page:' : _ref$itemsPerPageText,
      onChange = _ref.onChange,
      _ref$pageNumberText = _ref.pageNumberText,
      _pageNumberText = _ref$pageNumberText === void 0 ? 'Page Number' : _ref$pageNumberText,
      _ref$pageRangeText = _ref.pageRangeText,
      pageRangeText = _ref$pageRangeText === void 0 ? function (_current, total) {
    return "of ".concat(total, " ").concat(total === 1 ? 'page' : 'pages');
  } : _ref$pageRangeText,
      _ref$page = _ref.page,
      controlledPage = _ref$page === void 0 ? 1 : _ref$page,
      pageInputDisabled = _ref.pageInputDisabled,
      controlledPageSize = _ref.pageSize,
      pageSizeInputDisabled = _ref.pageSizeInputDisabled,
      controlledPageSizes = _ref.pageSizes,
      _ref$pageText = _ref.pageText,
      pageText = _ref$pageText === void 0 ? function (page) {
    return "page ".concat(page);
  } : _ref$pageText,
      _ref$pagesUnknown = _ref.pagesUnknown,
      pagesUnknown = _ref$pagesUnknown === void 0 ? false : _ref$pagesUnknown,
      size = _ref.size,
      totalItems = _ref.totalItems,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var inputId = (0, _useId.useFallbackId)(id);

  var _useState = (0, _react.useState)(function () {
    return mapPageSizesToObject(controlledPageSizes);
  }),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      pageSizes = _useState2[0],
      setPageSizes = _useState2[1];

  var _useState3 = (0, _react.useState)(controlledPageSizes),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevPageSizes = _useState4[0],
      setPrevPageSizes = _useState4[1];

  var _useState5 = (0, _react.useState)(controlledPage),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      page = _useState6[0],
      setPage = _useState6[1];

  var _useState7 = (0, _react.useState)(controlledPage),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      prevControlledPage = _useState8[0],
      setPrevControlledPage = _useState8[1];

  var _useState9 = (0, _react.useState)(function () {
    return getPageSize(pageSizes, controlledPageSize);
  }),
      _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
      pageSize = _useState10[0],
      setPageSize = _useState10[1];

  var _useState11 = (0, _react.useState)(controlledPageSize),
      _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
      prevControlledPageSize = _useState12[0],
      setPrevControlledPageSize = _useState12[1];

  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--pagination"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--pagination--").concat(size), size), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
  var totalPages = Math.max(Math.ceil(totalItems / pageSize), 1);
  var backButtonDisabled = disabled || page === 1;
  var backButtonClasses = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--pagination__button"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--pagination__button--backward"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--pagination__button--no-index"), backButtonDisabled), _cx2));
  var forwardButtonDisabled = disabled || page === totalPages;
  var forwardButtonClasses = (0, _classnames.default)((_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--pagination__button"), true), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--pagination__button--forward"), true), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--pagination__button--no-index"), forwardButtonDisabled), _cx3));
  var selectItems = renderSelectItems(totalPages); // Sync state with props

  if (controlledPage !== prevControlledPage) {
    setPage(controlledPage);
    setPrevControlledPage(controlledPage);
  }

  if (controlledPageSize !== prevControlledPageSize) {
    setPageSize(getPageSize(pageSizes, controlledPageSize));
    setPrevControlledPageSize(controlledPageSize);
  }

  if (!(0, _array.equals)(controlledPageSizes, prevPageSizes)) {
    var _pageSizes = mapPageSizesToObject(controlledPageSizes);

    var hasPageSize = _pageSizes.find(function (size) {
      return size.value === pageSize;
    }); // Reset page to 1 if the current pageSize is not included in the new page
    // sizes


    if (!hasPageSize) {
      setPage(1);
    }

    setPageSizes(_pageSizes);
    setPrevPageSizes(controlledPageSizes);
  }

  function handleSizeChange(event) {
    var pageSize = Number(event.target.value);
    var changes = {
      pageSize: pageSize,
      page: 1
    };
    setPage(changes.page);
    setPageSize(changes.pageSize);

    if (onChange) {
      onChange(changes);
    }
  }

  function handlePageInputChange(event) {
    var page = Number(event.target.value);

    if (page > 0 && page <= Math.max(Math.ceil(totalItems / pageSize), 1)) {
      setPage(page);

      if (onChange) {
        onChange({
          page: page,
          pageSize: pageSize
        });
      }
    }
  }

  function incrementPage() {
    var nextPage = page + 1;
    setPage(nextPage);

    if (onChange) {
      onChange({
        page: nextPage,
        pageSize: pageSize
      });
    }
  }

  function decrementPage() {
    var nextPage = page - 1;
    setPage(nextPage);

    if (onChange) {
      onChange({
        page: nextPage,
        pageSize: pageSize
      });
    }
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: className
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--pagination__left")
  }, /*#__PURE__*/_react.default.createElement("label", {
    id: "".concat(prefix, "-pagination-select-").concat(inputId, "-count-label"),
    className: "".concat(prefix, "--pagination__text"),
    htmlFor: "".concat(prefix, "-pagination-select-").concat(inputId)
  }, itemsPerPageText), /*#__PURE__*/_react.default.createElement(_Select.default, {
    id: "".concat(prefix, "-pagination-select-").concat(inputId),
    className: "".concat(prefix, "--select__item-count"),
    labelText: "",
    hideLabel: true,
    noLabel: true,
    inline: true,
    onChange: handleSizeChange,
    disabled: pageSizeInputDisabled || disabled,
    value: pageSize
  }, pageSizes.map(function (sizeObj) {
    return /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      key: sizeObj.value,
      value: sizeObj.value,
      text: String(sizeObj.text)
    });
  })), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--pagination__text ").concat(prefix, "--pagination__items-count")
  }, pagesUnknown ? itemText(pageSize * (page - 1) + 1, page * pageSize) : itemRangeText(Math.min(pageSize * (page - 1) + 1, totalItems), Math.min(page * pageSize, totalItems), totalItems))), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--pagination__right")
  }, /*#__PURE__*/_react.default.createElement(_Select.default, {
    id: "".concat(prefix, "-pagination-select-").concat(inputId, "-right"),
    className: "".concat(prefix, "--select__page-number"),
    labelText: "Page number, of ".concat(totalPages, " pages"),
    inline: true,
    hideLabel: true,
    onChange: handlePageInputChange,
    value: page,
    disabled: pageInputDisabled || disabled
  }, selectItems), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--pagination__text")
  }, pagesUnknown ? pageText(page) : pageRangeText(page, totalPages)), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--pagination__control-buttons")
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "ghost",
    className: backButtonClasses,
    hasIconOnly: true,
    renderIcon: _iconsReact.CaretLeft16,
    iconDescription: backwardText,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    onClick: decrementPage,
    disabled: backButtonDisabled
  }), /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "ghost",
    className: forwardButtonClasses,
    hasIconOnly: true,
    renderIcon: _iconsReact.CaretRight16,
    iconDescription: forwardText,
    tooltipAlignment: "end",
    tooltipPosition: "top",
    onClick: incrementPage,
    disabled: forwardButtonDisabled || isLastPage
  }))));
}

Pagination.propTypes = {
  /**
   * The description for the backward icon.
   */
  backwardText: _propTypes.default.string,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the backward/forward buttons, as well as the page select elements,  should be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * The description for the forward icon.
   */
  forwardText: _propTypes.default.string,

  /**
   * The unique ID of this component instance.
   */
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  // TODO: remove when v9 is deprecated

  /**
   * `true` if the current page should be the last page.
   */
  isLastPage: _propTypes.default.bool,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the range of items.
   */
  itemRangeText: _propTypes.default.func,

  /**
   * A variant of `itemRangeText`, used if the total number of items is unknown.
   */
  itemText: _propTypes.default.func,

  /**
   * The translatable text indicating the number of items per page.
   */
  itemsPerPageText: _propTypes.default.string,

  /**
   * The callback function called when the current page changes.
   */
  onChange: _propTypes.default.func,

  /**
   * The current page.
   */
  page: _propTypes.default.number,

  /**
   * `true` if the select box to change the page should be disabled.
   */
  pageInputDisabled: _propTypes.default.bool,
  pageNumberText: _propTypes.default.string,

  /**
   * A function returning PII showing where the current page is.
   */
  pageRangeText: _propTypes.default.func,

  /**
   * The number dictating how many items a page contains.
   */
  pageSize: _propTypes.default.number,

  /**
   * `true` if the select box to change the items per page should be disabled.
   */
  pageSizeInputDisabled: _propTypes.default.bool,

  /**
   * The choices for `pageSize`.
   */
  pageSizes: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.number), _propTypes.default.arrayOf(_propTypes.default.shape({
    text: _propTypes.default.text,
    value: _propTypes.default.number
  }))]).isRequired,

  /**
   * The translatable text showing the current page.
   */
  pageText: _propTypes.default.func,

  /**
   * `true` if the total number of items is unknown.
   */
  pagesUnknown: _propTypes.default.bool,

  /**
   * Specify the size of the Pagination. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg']),

  /**
   * The total number of items.
   */
  totalItems: _propTypes.default.number
};
var _default = Pagination;
exports.default = _default;