"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames3 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../../Button"));

var _Select = _interopRequireDefault(require("../../Select"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _excluded = ["backwardText", "children", "className", "disabled", "forwardText", "id", "initialPage", "itemsPerPageText", "itemRangeText", "itemText", "onChange", "pageRangeText", "pageSize", "pageSizes", "pageText", "pagesUnknown", "totalItems"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

function Pagination(_ref) {
  var backwardText = _ref.backwardText,
      children = _ref.children,
      className = _ref.className,
      disabled = _ref.disabled,
      forwardText = _ref.forwardText,
      id = _ref.id,
      initialPage = _ref.initialPage,
      itemsPerPageText = _ref.itemsPerPageText,
      itemRangeText = _ref.itemRangeText,
      itemText = _ref.itemText,
      onChange = _ref.onChange,
      pageRangeText = _ref.pageRangeText,
      pageSize = _ref.pageSize,
      pageSizes = _ref.pageSizes,
      pageText = _ref.pageText,
      pagesUnknown = _ref.pagesUnknown,
      totalItems = _ref.totalItems,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(initialPage),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      currentPage = _useState2[0],
      setCurrentPage = _useState2[1];

  var _useState3 = (0, _react.useState)(pageSize),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      currentPageSize = _useState4[0],
      setCurrentPageSize = _useState4[1];

  var totalPages = totalItems ? Math.max(Math.ceil(totalItems / currentPageSize), 1) : undefined;
  var backButtonDisabled = disabled || currentPage === 1;
  var forwardButtonDisabled = disabled || currentPage === totalPages;

  function onSetPage(newPage) {
    setCurrentPage(Number(newPage));
  }

  function incrementPage() {
    var page = currentPage + 1;
    setCurrentPage(page);
    onChange({
      page: page,
      pageSize: currentPageSize
    });
  }

  function decrementPage() {
    var page = currentPage - 1;
    setCurrentPage(page);
    onChange({
      page: page,
      pageSize: currentPageSize
    });
  }

  var namespace = "".concat(prefix, "--unstable-pagination");
  return /*#__PURE__*/_react.default.createElement("section", (0, _extends2.default)({
    className: (0, _classnames3.default)(namespace, className)
  }, other), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(namespace, "__left")
  }, pageSizes && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("label", {
    id: "".concat(namespace, "__page-sizer__counter-").concat(id),
    className: "".concat(namespace, "__text"),
    htmlFor: "".concat(namespace, "__page-sizer__input-").concat(id)
  }, itemsPerPageText), /*#__PURE__*/_react.default.createElement(_Select.default, {
    id: "".concat(namespace, "__page-sizer__input-").concat(id),
    className: "".concat(namespace, "__page-sizer"),
    labelText: "",
    hideLabel: true,
    noLabel: true,
    inline: true,
    onChange: function onChange(event) {
      return setCurrentPageSize(Number(event.target.value));
    },
    value: currentPageSize
  }, pageSizes.map(function (size) {
    return /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      key: size,
      value: size,
      text: String(size)
    });
  }))), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(namespace, "__text")
  }, totalItems && !pagesUnknown && itemRangeText(Math.min(currentPageSize * (currentPage - 1) + 1, totalItems), Math.min(currentPage * currentPageSize, totalItems), totalItems), totalItems && pagesUnknown && itemText(currentPageSize * (currentPage - 1) + 1, currentPage * currentPageSize), !totalItems && itemText(currentPageSize * (currentPage - 1) + 1, currentPage * currentPageSize))), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(namespace, "__right")
  }, children && totalItems && children({
    currentPage: currentPage,
    currentPageSize: currentPageSize,
    onSetPage: onSetPage,
    totalPages: totalPages
  }), children && totalItems && !pagesUnknown && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(namespace, "__text")
  }, pageRangeText('', totalPages)), children && !totalItems && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(namespace, "__text")
  }, pageText(currentPage)), !children && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(namespace, "__text")
  }, !totalItems ? pageText(currentPage) : pageRangeText(currentPage, totalPages)), /*#__PURE__*/_react.default.createElement(_Button.default, {
    className: (0, _classnames3.default)("".concat(namespace, "__button"), "".concat(namespace, "__button--backward"), (0, _defineProperty2.default)({}, "".concat(namespace, "__button--no-index"), backButtonDisabled)),
    onClick: function onClick() {
      return decrementPage();
    },
    disabled: backButtonDisabled,
    hasIconOnly: true,
    renderIcon: _iconsReact.CaretLeft16,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    iconDescription: backwardText
  }), /*#__PURE__*/_react.default.createElement(_Button.default, {
    className: (0, _classnames3.default)("".concat(namespace, "__button"), "".concat(namespace, "__button--forward"), (0, _defineProperty2.default)({}, "".concat(namespace, "__button--no-index"), forwardButtonDisabled)),
    onClick: function onClick() {
      return incrementPage();
    },
    disabled: forwardButtonDisabled,
    hasIconOnly: true,
    renderIcon: _iconsReact.CaretRight16,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    iconDescription: forwardText
  })));
}

Pagination.propTypes = {
  /**
   * The description for the backward icon.
   */
  backwardText: _propTypes.default.string,

  /**
   * The children of the pagination component.
   */
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.func]),

  /**
   * Extra classes to add.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the backward/forward buttons should be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * The description for the forward icon.
   */
  forwardText: _propTypes.default.string,

  /** The unique ID of this component instance. */
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * The initial active page when the component is first mounted.
   */
  initialPage: _propTypes.default.number,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the range of items.
   */
  itemRangeText: _propTypes.default.func,

  /**
   * A variant of `itemRangeText`, used if the total number of items is unknown.
   */
  itemText: _propTypes.default.func,

  /**
   * The translatable text indicating the number of items per page.
   */
  itemsPerPageText: _propTypes.default.string,

  /**
   * The callback function called when the current page changes.
   */
  onChange: _propTypes.default.func,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the total number of pages.
   */
  pageRangeText: _propTypes.default.func,

  /**
   * The number dictating how many items a page contains.
   */
  pageSize: _propTypes.default.number,

  /**
   * The choices for `pageSize`.
   */
  pageSizes: _propTypes.default.arrayOf(_propTypes.default.number),

  /**
   * The translatable text showing the current page.
   */
  pageText: _propTypes.default.func,

  /**
   * `true` if total number of pages is unknown.
   */
  pagesUnknown: _propTypes.default.bool,

  /**
   * The total number of items.
   * You need to provide total items to calculate total page,
   * which is required by a child like the `PageSelector`
   * to know how many pages to display.
   */
  totalItems: _propTypes.default.number
};
Pagination.defaultProps = {
  backwardText: 'Previous page',
  className: null,
  children: undefined,
  disabled: false,
  forwardText: 'Next page',
  id: 1,
  itemsPerPageText: 'Items per page:',
  itemRangeText: function itemRangeText(min, max, total) {
    return "".concat(min, "\u2013").concat(max, " of ").concat(total, " items");
  },
  itemText: function itemText(min, max) {
    return "".concat(min, "\u2013").concat(max, " items");
  },
  initialPage: 1,
  pageRangeText: function pageRangeText(current, total) {
    return "".concat(current, " of ").concat(total, " pages");
  },
  pageSize: 10,
  pageSizes: undefined,
  pageText: function pageText(page) {
    return "page ".concat(page);
  },
  pagesUnknown: false,
  totalItems: undefined
};
var _default = Pagination;
exports.default = _default;