"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof3 = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames4 = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _array = require("../../tools/array");

var _Button = _interopRequireDefault(require("../Button"));

var _excluded = ["backwardText", "className", "forwardText", "id", "itemsPerPageText", "itemRangeText", "pageRangeText", "pageSize", "pageSizes", "itemText", "pageText", "pageNumberText", "pagesUnknown", "isLastPage", "disabled", "pageInputDisabled", "pageSizeInputDisabled", "totalItems", "onChange", "page", "size"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
var instanceId = 0;

var mapPageSizesToObject = function mapPageSizesToObject(sizes) {
  return (0, _typeof2.default)(sizes[0]) === 'object' && sizes[0] !== null ? sizes : sizes.map(function (size) {
    return {
      text: size,
      value: size
    };
  });
};

var Pagination = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(Pagination, _Component);

  var _super = _createSuper(Pagination);

  function Pagination(props) {
    var _this;

    (0, _classCallCheck2.default)(this, Pagination);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSizeChange", function (evt) {
      var pageSize = Number(evt.target.value);

      _this.setState({
        pageSize: pageSize,
        page: 1
      });

      _this.props.onChange({
        page: 1,
        pageSize: pageSize
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handlePageChange", function (evt) {
      _this.setState({
        page: evt.target.value
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handlePageInputChange", function (evt) {
      var page = Number(evt.target.value);

      if (page > 0 && page <= Math.max(Math.ceil(_this.props.totalItems / _this.state.pageSize), 1)) {
        _this.setState({
          page: page
        });

        _this.props.onChange({
          page: page,
          pageSize: _this.state.pageSize
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "incrementPage", function () {
      var page = _this.state.page + 1;

      _this.setState({
        page: page
      });

      _this.props.onChange({
        page: page,
        pageSize: _this.state.pageSize
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "decrementPage", function () {
      var page = _this.state.page - 1;

      _this.setState({
        page: page
      });

      _this.props.onChange({
        page: page,
        pageSize: _this.state.pageSize
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSelectItems", function (total) {
      var counter = 1;
      var itemArr = [];

      while (counter <= total) {
        itemArr.push( /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
          key: counter,
          value: counter,
          text: String(counter)
        }));
        counter++;
      }

      return itemArr;
    });
    var _this$props = _this.props,
        _pageSizes = _this$props.pageSizes,
        _page = _this$props.page,
        _pageSize = _this$props.pageSize;
    var pageSizes = mapPageSizesToObject(_pageSizes);
    _this.state = {
      page: _page,
      pageSize: _pageSize && pageSizes.some(function (sizeObj) {
        return _pageSize === sizeObj.value;
      }) ? _pageSize : pageSizes[0].value,
      prevPageSizes: pageSizes,
      prevPage: _page,
      prevPageSize: _pageSize
    };
    _this.uniqueId = ++instanceId;
    return _this;
  }

  (0, _createClass2.default)(Pagination, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          backwardText = _this$props2.backwardText,
          className = _this$props2.className,
          forwardText = _this$props2.forwardText,
          id = _this$props2.id,
          itemsPerPageText = _this$props2.itemsPerPageText,
          itemRangeText = _this$props2.itemRangeText,
          pageRangeText = _this$props2.pageRangeText,
          pageSize = _this$props2.pageSize,
          _pageSizes = _this$props2.pageSizes,
          itemText = _this$props2.itemText,
          pageText = _this$props2.pageText,
          pageNumberText = _this$props2.pageNumberText,
          pagesUnknown = _this$props2.pagesUnknown,
          isLastPage = _this$props2.isLastPage,
          disabled = _this$props2.disabled,
          pageInputDisabled = _this$props2.pageInputDisabled,
          pageSizeInputDisabled = _this$props2.pageSizeInputDisabled,
          totalItems = _this$props2.totalItems,
          onChange = _this$props2.onChange,
          pageNumber = _this$props2.page,
          size = _this$props2.size,
          other = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);
      var classNames = (0, _classnames4.default)("".concat(prefix, "--pagination"), className, (0, _defineProperty2.default)({}, "".concat(prefix, "--pagination--").concat(size), size));
      var inputId = id || this.uniqueId;
      var _this$state = this.state,
          statePage = _this$state.page,
          statePageSize = _this$state.pageSize;
      var totalPages = Math.max(Math.ceil(totalItems / statePageSize), 1);
      var backButtonDisabled = disabled || statePage === 1;
      var backButtonClasses = (0, _classnames4.default)("".concat(prefix, "--pagination__button"), "".concat(prefix, "--pagination__button--backward"), (0, _defineProperty2.default)({}, "".concat(prefix, "--pagination__button--no-index"), backButtonDisabled));
      var forwardButtonDisabled = disabled || statePage === totalPages;
      var forwardButtonClasses = (0, _classnames4.default)("".concat(prefix, "--pagination__button"), "".concat(prefix, "--pagination__button--forward"), (0, _defineProperty2.default)({}, "".concat(prefix, "--pagination__button--no-index"), forwardButtonDisabled));
      var selectItems = this.renderSelectItems(totalPages);
      var pageSizes = mapPageSizesToObject(_pageSizes);
      return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: classNames
      }, other), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--pagination__left")
      }, /*#__PURE__*/_react.default.createElement("label", {
        id: "".concat(prefix, "-pagination-select-").concat(inputId, "-count-label"),
        className: "".concat(prefix, "--pagination__text"),
        htmlFor: "".concat(prefix, "-pagination-select-").concat(inputId)
      }, itemsPerPageText), /*#__PURE__*/_react.default.createElement(_Select.default, {
        id: "".concat(prefix, "-pagination-select-").concat(inputId),
        className: "".concat(prefix, "--select__item-count"),
        labelText: "",
        hideLabel: true,
        noLabel: true,
        inline: true,
        onChange: this.handleSizeChange,
        disabled: pageSizeInputDisabled || disabled,
        value: statePageSize
      }, pageSizes.map(function (sizeObj) {
        return /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
          key: sizeObj.value,
          value: sizeObj.value,
          text: String(sizeObj.text)
        });
      })), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--pagination__text ").concat(prefix, "--pagination__items-count")
      }, pagesUnknown ? itemText(statePageSize * (statePage - 1) + 1, statePage * statePageSize) : itemRangeText(Math.min(statePageSize * (statePage - 1) + 1, totalItems), Math.min(statePage * statePageSize, totalItems), totalItems))), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--pagination__right")
      }, /*#__PURE__*/_react.default.createElement(_Select.default, {
        id: "".concat(prefix, "-pagination-select-").concat(inputId, "-right"),
        className: "".concat(prefix, "--select__page-number"),
        labelText: "Page number, of ".concat(totalPages, " pages"),
        inline: true,
        hideLabel: true,
        onChange: this.handlePageInputChange,
        value: statePage,
        disabled: pageInputDisabled || disabled
      }, selectItems), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--pagination__text")
      }, pagesUnknown ? pageText(statePage) : pageRangeText(statePage, totalPages)), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--pagination__control-buttons")
      }, /*#__PURE__*/_react.default.createElement(_Button.default, {
        kind: "ghost",
        className: backButtonClasses,
        hasIconOnly: true,
        renderIcon: _iconsReact.CaretLeft16,
        iconDescription: backwardText,
        tooltipAlignment: "center",
        tooltipPosition: "top",
        onClick: this.decrementPage,
        disabled: backButtonDisabled
      }), /*#__PURE__*/_react.default.createElement(_Button.default, {
        kind: "ghost",
        className: forwardButtonClasses,
        hasIconOnly: true,
        renderIcon: _iconsReact.CaretRight16,
        iconDescription: forwardText,
        tooltipAlignment: "end",
        tooltipPosition: "top",
        onClick: this.incrementPage,
        disabled: forwardButtonDisabled || isLastPage
      }))));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var _pageSizes = _ref.pageSizes,
          page = _ref.page,
          pageSize = _ref.pageSize;
      var prevPageSizes = state.prevPageSizes,
          prevPage = state.prevPage,
          prevPageSize = state.prevPageSize,
          currentPage = state.page,
          currentPageSize = state.pageSize;
      var pageSizes = mapPageSizesToObject(_pageSizes);
      var pageSizesValues = pageSizes.map(function (sizeObj) {
        return sizeObj.value;
      });
      var prevPageSizesValues = prevPageSizes.map(function (sizeObj) {
        return sizeObj.value;
      });
      var pageSizesChanged = !(0, _array.equals)(pageSizesValues, prevPageSizesValues);

      if (pageSizesChanged && !pageSizes.some(function (sizeObj) {
        return pageSize === sizeObj.value;
      })) {
        pageSize = pageSizes[0].value;
      }

      var pageChanged = page !== prevPage;
      var pageSizeChanged = pageSize !== prevPageSize;
      return !pageSizesChanged && !pageChanged && !pageSizeChanged ? null : {
        page: pageSizeChanged && 1 || pageChanged && page || currentPage,
        pageSize: pageSizeChanged ? pageSize : currentPageSize,
        prevPageSizes: pageSizes,
        prevPage: page,
        prevPageSize: pageSize
      };
    }
  }]);
  return Pagination;
}(_react.Component);

exports.default = Pagination;
(0, _defineProperty2.default)(Pagination, "propTypes", {
  /**
   * The description for the backward icon.
   */
  backwardText: _propTypes.default.string,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the backward/forward buttons, as well as the page select elements,  should be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * The description for the forward icon.
   */
  forwardText: _propTypes.default.string,

  /**
   * The unique ID of this component instance.
   */
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  // TODO: remove when v9 is deprecated

  /**
   * `true` if the current page should be the last page.
   */
  isLastPage: _propTypes.default.bool,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the range of items.
   */
  itemRangeText: _propTypes.default.func,

  /**
   * A variant of `itemRangeText`, used if the total number of items is unknown.
   */
  itemText: _propTypes.default.func,

  /**
   * The translatable text indicating the number of items per page.
   */
  itemsPerPageText: _propTypes.default.string,

  /**
   * The callback function called when the current page changes.
   */
  onChange: _propTypes.default.func,

  /**
   * The current page.
   */
  page: _propTypes.default.number,

  /**
   * `true` if the select box to change the page should be disabled.
   */
  pageInputDisabled: _propTypes.default.bool,
  pageNumberText: _propTypes.default.string,

  /**
   * A function returning PII showing where the current page is.
   */
  pageRangeText: _propTypes.default.func,

  /**
   * The number dictating how many items a page contains.
   */
  pageSize: _propTypes.default.number,

  /**
   * `true` if the select box to change the items per page should be disabled.
   */
  pageSizeInputDisabled: _propTypes.default.bool,

  /**
   * The choices for `pageSize`.
   */
  pageSizes: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.number), _propTypes.default.arrayOf(_propTypes.default.shape({
    text: _propTypes.default.text,
    value: _propTypes.default.number
  }))]).isRequired,

  /**
   * The translatable text showing the current page.
   */
  pageText: _propTypes.default.func,

  /**
   * `true` if the total number of items is unknown.
   */
  pagesUnknown: _propTypes.default.bool,

  /**
   * Specify the size of the Pagination. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg']),

  /**
   * The total number of items.
   */
  totalItems: _propTypes.default.number
});
(0, _defineProperty2.default)(Pagination, "defaultProps", {
  backwardText: 'Previous page',
  itemRangeText: function itemRangeText(min, max, total) {
    return "".concat(min, "\u2013").concat(max, " of ").concat(total, " items");
  },
  forwardText: 'Next page',
  itemsPerPageText: 'Items per page:',
  pageNumberText: 'Page Number',
  pageRangeText: function pageRangeText(current, total) {
    return "of ".concat(total, " ").concat(total === 1 ? 'page' : 'pages');
  },
  disabled: false,
  page: 1,
  pagesUnknown: false,
  isLastPage: false,
  itemText: function itemText(min, max) {
    return "".concat(min, "\u2013").concat(max, " items");
  },
  pageText: function pageText(page) {
    return "page ".concat(page);
  }
});