"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Nested = exports.CustomIcon = exports._OverflowMenu = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _Menu = _interopRequireDefault(require("../../Menu"));

var _storybookUtils = require("../../Menu/_storybook-utils");

var _OverflowMenu2 = _interopRequireDefault(require("./OverflowMenu"));

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Menu/OverflowMenu',
  parameters: {
    component: _Menu.default
  }
};
exports.default = _default;

var Story = function Story(items) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return /*#__PURE__*/_react.default.createElement(_storybookUtils.StoryFrame, null, /*#__PURE__*/_react.default.createElement(_OverflowMenu2.default, props, (0, _storybookUtils.buildMenu)(items)));
};

var _OverflowMenu = function _OverflowMenu() {
  return Story([{
    type: 'item',
    label: 'Stop app'
  }, {
    type: 'item',
    label: 'Restart app'
  }, {
    type: 'item',
    label: 'Rename app'
  }, {
    type: 'item',
    label: 'Edit routes and access'
  }, {
    type: 'divider'
  }, {
    type: 'item',
    label: 'Delete app',
    kind: 'danger'
  }]);
};

exports._OverflowMenu = _OverflowMenu;

var CustomIcon = function CustomIcon() {
  return Story([{
    type: 'radiogroup',
    label: 'Sort by',
    items: ['Name', 'Date created', 'Date last modified', 'Size'],
    initialSelectedItem: 'Date created'
  }, {
    type: 'divider'
  }, {
    type: 'radiogroup',
    label: 'Sort order',
    items: ['Ascending', 'Descending'],
    initialSelectedItem: 'Descending'
  }], {
    renderIcon: _iconsReact.ArrowsVertical16
  });
};

exports.CustomIcon = CustomIcon;

var Nested = function Nested() {
  return Story([{
    type: 'item',
    label: 'Level 1'
  }, {
    type: 'item',
    label: 'Level 1'
  }, {
    type: 'item',
    label: 'Level 1',
    children: [{
      type: 'item',
      label: 'Level 2'
    }, {
      type: 'item',
      label: 'Level 2'
    }, {
      type: 'item',
      label: 'Level 2'
    }]
  }, {
    type: 'item',
    label: 'Level 1'
  }]);
};

exports.Nested = Nested;