"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _useId = require("../../../internal/useId");

var _Menu = _interopRequireDefault(require("../../Menu"));

var _keyboard = require("../../../internal/keyboard");

var _excluded = ["children", "renderIcon", "size"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;
var defaultSize = 'md';

function OverflowMenu(_ref) {
  var children = _ref.children,
      _ref$renderIcon = _ref.renderIcon,
      IconElement = _ref$renderIcon === void 0 ? _iconsReact.OverflowMenuVertical16 : _ref$renderIcon,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? defaultSize : _ref$size,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var id = (0, _useId.useId)('overflowmenu');

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var _useState3 = (0, _react.useState)([[0, 0], [0, 0]]),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      position = _useState4[0],
      setPosition = _useState4[1];

  var triggerRef = (0, _react.useRef)(null);

  function openMenu() {
    if (triggerRef.current) {
      var _triggerRef$current$g = triggerRef.current.getBoundingClientRect(),
          left = _triggerRef$current$g.left,
          top = _triggerRef$current$g.top,
          right = _triggerRef$current$g.right,
          bottom = _triggerRef$current$g.bottom;

      setPosition([[left, right], [top, bottom]]);
    }

    setOpen(true);
  }

  function closeMenu() {
    setOpen(false);
  }

  function handleClick() {
    if (open) {
      closeMenu();
    } else {
      openMenu();
    }
  }

  function handleMousedown(e) {
    // prevent default for mousedown on trigger element to avoid
    // the "blur" event from firing on the menu as this would close
    // it and immediately re-open since "click" event is fired after
    // "blur" event.
    e.preventDefault();
  }

  function handleKeyPress(e) {
    if (open && (0, _keyboard.matches)(e, [_keyboard.keys.ArrowUp, _keyboard.keys.ArrowRight, _keyboard.keys.ArrowDown, _keyboard.keys.ArrowLeft])) {
      e.preventDefault();
    }
  }

  var containerClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu__container"));
  var triggerClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu"), (0, _defineProperty2.default)({}, "".concat(prefix, "--overflow-menu--open"), open), size !== defaultSize && "".concat(prefix, "--overflow-menu--").concat(size));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: containerClasses,
    "aria-owns": id
  }, /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, {
    type: "button",
    "aria-haspopup": true,
    "aria-expanded": open,
    className: triggerClasses,
    onClick: handleClick,
    onMouseDown: handleMousedown,
    onKeyDown: handleKeyPress,
    ref: triggerRef
  }), /*#__PURE__*/_react.default.createElement(IconElement, null)), /*#__PURE__*/_react.default.createElement(_Menu.default, {
    id: id,
    size: size,
    open: open,
    onClose: closeMenu,
    x: position[0],
    y: position[1]
  }, children));
}

OverflowMenu.propTypes = {
  /**
   * Specify the children of the OverflowMenu
   */
  children: _propTypes.default.node,

  /**
   * Function called to override icon rendering.
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the size of the menu, from a list of available sizes.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg'])
};
var _default = OverflowMenu;
exports.default = _default;