"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "nested", "native", "isExpressive"];

var OrderedList = function OrderedList(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      nested = _ref.nested,
      native = _ref.native,
      isExpressive = _ref.isExpressive,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classNames = (0, _classnames2.default)((_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--ordered"), !native), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--ordered--native"), native), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--nested"), nested), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--expressive"), isExpressive), _classnames), className);
  return /*#__PURE__*/_react.default.createElement("ol", (0, _extends2.default)({
    className: classNames
  }, other), children);
};

OrderedList.propTypes = {
  /**
   * Provide list items to be rendered in the ordered list
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional className to be applied to the containing <ol> node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether this ordered list expressive or not
   */
  isExpressive: _propTypes.default.bool,

  /**
   * Specify whether this ordered list should use native list styles instead of custom counter
   */
  native: _propTypes.default.bool,

  /**
   * Specify whether this ordered list is nested inside of another nested list
   */
  nested: _propTypes.default.bool
};
OrderedList.defaultProps = {
  nested: false,
  native: false,
  isExpressive: false
};
var _default = OrderedList;
exports.default = _default;