"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NumberInput = exports.translationIds = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _requiredIfValueExists = _interopRequireDefault(require("../../prop-types/requiredIfValueExists"));

var _useNormalizedInputProps = require("../../internal/useNormalizedInputProps");

var _FeatureFlags = require("../../internal/FeatureFlags");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags2 = require("../FeatureFlags");

var _excluded = ["className", "disabled", "iconDescription", "id", "hideLabel", "hideSteppers", "label", "max", "min", "step", "value", "readOnly", "invalid", "invalidText", "warn", "warnText", "helperText", "ariaLabel", "light", "allowEmpty", "innerRef", "translateWithId", "isMobile", "size", "defaultValue"];

var _defaultTranslations;

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
var translationIds = {
  'increment.number': 'increment.number',
  'decrement.number': 'decrement.number'
};
exports.translationIds = translationIds;
var defaultTranslations = (_defaultTranslations = {}, (0, _defineProperty2.default)(_defaultTranslations, translationIds['increment.number'], 'Increment number'), (0, _defineProperty2.default)(_defaultTranslations, translationIds['decrement.number'], 'Decrement number'), _defaultTranslations);

var capMin = function capMin(min, value) {
  return isNaN(min) || !min && min !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.max(min, value);
};

var capMax = function capMax(max, value) {
  return isNaN(max) || !max && max !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.min(max, value);
};

var NumberInput = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(NumberInput, _Component);

  var _super = _createSuper(NumberInput);

  function NumberInput(props) {
    var _this;

    (0, _classCallCheck2.default)(this, NumberInput);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_inputRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function (evt) {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange;

      if (!disabled) {
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;
        var prevValue = _this.state.value;
        var value = evt.target.value;
        var direction = prevValue < value ? 'up' : 'down';

        _this.setState({
          value: value
        }, function () {
          if (_FeatureFlags.useControlledStateWithValue) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          } else if (onChange) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          }
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleArrowClick", function (evt, direction) {
      var value = typeof _this.state.value === 'string' ? Number(_this.state.value) : _this.state.value;
      var _this$props2 = _this.props,
          disabled = _this$props2.disabled,
          min = _this$props2.min,
          max = _this$props2.max,
          step = _this$props2.step,
          onChange = _this$props2.onChange,
          onClick = _this$props2.onClick;
      var conditional = direction === 'down' ? min !== undefined && value > min || min === undefined : max !== undefined && value < max || max === undefined;

      if (!disabled && conditional) {
        value = direction === 'down' ? value - step : value + step;
        value = capMax(max, capMin(min, value));
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;

        _this.setState({
          value: value
        }, function () {
          //TO-DO v11: update these events to return the same things --> evt, {value, direction}
          if (_FeatureFlags.useControlledStateWithValue) {
            onClick && onClick(evt, {
              value: value,
              direction: direction
            });
            onChange && onChange(evt, {
              value: value,
              direction: direction
            });
          } else {
            // value added as a 3rd argument rather than in same obj so it doesn't break in v10
            onClick && onClick(evt, direction, value);
            onChange && onChange(evt, direction, value);
          }
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_handleInputRef", function (ref) {
      _this._inputRef = ref;
    });
    _this.isControlled = props.value !== undefined;

    if (_FeatureFlags.useControlledStateWithValue && _this.isControlled) {
      // Skips the logic of setting initial state if this component is controlled
      _this.state = {};
      return (0, _possibleConstructorReturn2.default)(_this);
    }

    var _value = _FeatureFlags.useControlledStateWithValue || typeof props.defaultValue !== 'undefined' ? props.defaultValue : props.value;

    _value = _value === undefined ? 0 : _value;

    if (props.min || props.min === 0) {
      _value = Math.max(props.min, _value);
    }

    _this.state = {
      value: _value
    };
    return _this;
  }

  (0, _createClass2.default)(NumberInput, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames3,
          _classNames5,
          _this2 = this;

      var _this$props3 = this.props,
          className = _this$props3.className,
          disabled = _this$props3.disabled,
          iconDescription = _this$props3.iconDescription,
          id = _this$props3.id,
          hideLabel = _this$props3.hideLabel,
          hideSteppers = _this$props3.hideSteppers,
          label = _this$props3.label,
          max = _this$props3.max,
          min = _this$props3.min,
          step = _this$props3.step,
          value = _this$props3.value,
          readOnly = _this$props3.readOnly,
          invalid = _this$props3.invalid,
          invalidText = _this$props3.invalidText,
          warn = _this$props3.warn,
          warnText = _this$props3.warnText,
          helperText = _this$props3.helperText,
          ariaLabel = _this$props3.ariaLabel,
          light = _this$props3.light,
          allowEmpty = _this$props3.allowEmpty,
          ref = _this$props3.innerRef,
          t = _this$props3.translateWithId,
          isMobile = _this$props3.isMobile,
          size = _this$props3.size,
          defaultValue = _this$props3.defaultValue,
          other = (0, _objectWithoutProperties2.default)(_this$props3, _excluded);
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var numberInputClasses = (0, _classnames.default)("".concat(prefix, "--number ").concat(prefix, "--number--helpertext"), [enabled ? null : className], (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--readonly"), readOnly), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--nolabel"), hideLabel), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--nosteppers"), hideSteppers), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--mobile"), isMobile), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--number--").concat(size), size), _classNames));
      var isInputInvalid; // If the user supplied `invalid` through props, we'll defer to the passed in value

      if (invalid) {
        isInputInvalid = true;
      } else {
        // Otherwise, if we don't allow an empty value then we check to see
        // if the value is empty, or if it is out of range
        if (!allowEmpty && this.state.value === '') {
          isInputInvalid = true;
        } else {
          if (this.state.value !== '' && (this.state.value > max || this.state.value < min)) {
            isInputInvalid = true;
          }
        }
      }

      var normalizedProps = (0, _useNormalizedInputProps.useNormalizedInputProps)({
        id: id,
        readOnly: readOnly,
        disabled: disabled,
        invalid: isInputInvalid,
        invalidText: invalidText,
        warn: warn,
        warnText: warnText
      });
      var props = {
        disabled: normalizedProps.disabled,
        id: id,
        max: max,
        min: min,
        step: step,
        onChange: this.handleChange,
        value: _FeatureFlags.useControlledStateWithValue && this.isControlled ? value : this.state.value,
        readOnly: readOnly,
        'aria-label': label ? null : ariaLabel
      };
      var buttonProps = {
        disabled: disabled
      };
      var inputWrapperProps = {};

      if (normalizedProps.invalid) {
        inputWrapperProps['data-invalid'] = true;
      }

      var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), normalizedProps.disabled));
      var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
        className: helperTextClasses
      }, helperText) : null;
      var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--label--disabled"), normalizedProps.disabled), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _classNames3));
      var labelText = label ? /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, label) : null;
      var _ref = [t('increment.number'), t('decrement.number')],
          incrementNumLabel = _ref[0],
          decrementNumLabel = _ref[1];
      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--number__input-wrapper"), (0, _defineProperty2.default)({}, "".concat(prefix, "--number__input-wrapper--warning"), normalizedProps.warn));
      var iconClasses = (0, _classnames.default)((_classNames5 = {}, (0, _defineProperty2.default)(_classNames5, "".concat(prefix, "--number__invalid"), normalizedProps.invalid || normalizedProps.warn), (0, _defineProperty2.default)(_classNames5, "".concat(prefix, "--number__invalid--warning"), normalizedProps.warn), (0, _defineProperty2.default)(_classNames5, "".concat(prefix, "--number__readonly-icon"), readOnly), _classNames5));
      var ariaDescribedBy = null;

      if (normalizedProps.invalid) {
        ariaDescribedBy = normalizedProps.invalidId;
      }

      if (normalizedProps.warn) {
        ariaDescribedBy = normalizedProps.warnId;
      }

      return /*#__PURE__*/_react.default.createElement("div", {
        className: enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: numberInputClasses
      }, inputWrapperProps), function () {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, labelText, /*#__PURE__*/_react.default.createElement("div", {
          className: wrapperClasses
        }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
          "data-invalid": normalizedProps.invalid,
          "aria-invalid": normalizedProps.invalid,
          "aria-describedby": ariaDescribedBy,
          type: "number",
          pattern: "[0-9]*"
        }, other, props, {
          ref: (0, _mergeRefs.default)(ref, _this2._handleInputRef)
        })), normalizedProps.icon && /*#__PURE__*/_react.default.createElement(normalizedProps.icon, {
          className: iconClasses
        }), !hideSteppers && /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__controls")
        }, /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
          type: "button",
          className: "".concat(prefix, "--number__control-btn down-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'down');
          },
          title: decrementNumLabel || iconDescription,
          "aria-label": decrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/_react.default.createElement(_iconsReact.Subtract16, {
          className: "down-icon"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }), /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
          type: "button",
          className: "".concat(prefix, "--number__control-btn up-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'up');
          },
          title: incrementNumLabel || iconDescription,
          "aria-label": incrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/_react.default.createElement(_iconsReact.Add16, {
          className: "up-icon"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }))), normalizedProps.validation ? null : helper);
      }(), normalizedProps.validation));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var value = _ref2.value;
      var prevValue = state.prevValue;

      if (_FeatureFlags.useControlledStateWithValue && value === '' && prevValue !== '') {
        return {
          value: '',
          prevValue: ''
        };
      } // If `useControlledStateWithValue` feature flag is on, do nothing here.
      // Otherwise, do prop -> state sync with "value capping".
      //// Value capping removed in #8965
      //// value: capMax(max, capMin(min, value)), (L223)


      return _FeatureFlags.useControlledStateWithValue || prevValue === value ? null : {
        value: value,
        prevValue: value
      };
    }
    /**
     * The DOM node reference to the `<input>`.
     * @type {HTMLInputElement}
     */

  }]);
  return NumberInput;
}(_react.Component);

exports.NumberInput = NumberInput;
(0, _defineProperty2.default)(NumberInput, "propTypes", {
  /**
   * `true` to allow empty string.
   */
  allowEmpty: _propTypes.default.bool,

  /**
   * Provide a description that would be used to best describe the use case of the NumberInput component
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the wrapper node
   */
  className: _propTypes.default.string,

  /**
   * Optional starting value for uncontrolled state
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify whether you want the steppers to be hidden
   */
  hideSteppers: _propTypes.default.bool,

  /**
   * Provide a description for up/down icons that can be read by screen readers
   */
  iconDescription: _propTypes.default.string.isRequired,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify if the currently value is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: _propTypes.default.node,

  /**
   * `true` to use the mobile variant.
   */
  isMobile: (0, _deprecate.default)(_propTypes.default.bool, "The `isMobile` prop no longer needed as the default NumberInput styles are now identical to the mobile variant styles. This prop will be removed in the next major version of `carbon-components-react`"),

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: _propTypes.default.node,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * The maximum value.
   */
  max: _propTypes.default.number,

  /**
   * The minimum value.
   */
  min: _propTypes.default.number,

  /**
   * The new value is available in 'imaginaryTarget.value'
   * i.e. to get the value: evt.imaginaryTarget.value
   *
   * * _With_ `useControlledStateWithValue` feature flag, the signature of the event handler will be altered to provide additional context in the second parameter: `onChange(event, { value, direction })` where:
   *   * `event` is the (React) raw event
   *   * `value` is the new value
   *   * `direction` tells you the button you hit is up button or down button
   * * _Without_ this feature flag the event handler has `onChange(event, direction)` signature.
   */
  onChange: !_FeatureFlags.useControlledStateWithValue ? _propTypes.default.func : (0, _requiredIfValueExists.default)(_propTypes.default.func),

  /**
   * Provide an optional function to be called when the up/down button is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify if the component should be read-only
   */
  readOnly: _propTypes.default.bool,

  /**
   * Specify the size of the Number Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify how much the values should increase/decrease upon clicking on up/down button
   */
  step: _propTypes.default.number,

  /**
   * Provide custom text for the component for each translation id
   */
  translateWithId: _propTypes.default.func.isRequired,

  /**
   * Specify the value of the input
   */
  value: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});
(0, _defineProperty2.default)(NumberInput, "defaultProps", {
  disabled: false,
  hideLabel: false,
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? undefined : 'choose a number',
  step: 1,
  invalid: false,
  invalidText: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Provide invalidText',
  warn: false,
  warnText: '',
  ariaLabel: 'Numeric input field with increment and decrement buttons',
  helperText: '',
  light: false,
  allowEmpty: false,
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
});
(0, _defineProperty2.default)(NumberInput, "contextType", _FeatureFlags2.FeatureFlagContext);

var _default = function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/_react.default.createElement(NumberInput, (0, _extends2.default)({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'NumberInput';
  return /*#__PURE__*/_react.default.forwardRef(forwardRef);
}();

exports.default = _default;