"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Playground = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _NumberInput = _interopRequireDefault(require("../NumberInput"));

var _NumberInput2 = require("./NumberInput");

var _NumberInput3 = _interopRequireDefault(require("../NumberInput/NumberInput.Skeleton"));

var _NumberInput4 = _interopRequireDefault(require("./NumberInput.mdx"));

var _excluded = ["numberInputArrowTranslationIds"];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var props = function props() {
  return {
    className: 'some-class',
    id: 'tj-input',
    label: (0, _addonKnobs.text)('Label (label)', 'NumberInput label'),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    hideSteppers: (0, _addonKnobs.boolean)('No steppers (hideSteppers)', false),
    min: (0, _addonKnobs.number)('Minimum value (min)', 0),
    max: (0, _addonKnobs.number)('Maximum value (max)', 100),
    value: (0, _addonKnobs.number)('Value (value)', 50),
    step: (0, _addonKnobs.number)('Step of up/down arrow (step)', 10),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    readOnly: (0, _addonKnobs.boolean)('Read only (readOnly)', false),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'Number is not valid'),
    warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
    warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'A high threshold may impact performance'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    onChange: (0, _addonActions.action)('onChange'),
    onClick: (0, _addonActions.action)('onClick'),
    allowEmpty: (0, _addonKnobs.boolean)('Allow empty value (allowEmpty)', false),
    numberInputArrowTranslationIds: (0, _addonKnobs.object)('Number input arrow icon translation IDs (for translateWithId callback)', {
      'increment.number': 'Increment number',
      'decrement.number': 'Decrement number'
    })
  };
};

var _default = {
  title: 'Components/NumberInput',
  component: _NumberInput2.NumberInput,
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _NumberInput4.default
    },
    subcomponents: {
      NumberInputSkeleton: _NumberInput3.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_NumberInput.default, {
    id: "carbon-number",
    min: 0,
    max: 100,
    value: 50,
    label: "NumberInput label",
    helperText: "Optional helper text.",
    invalidText: "Number is not valid"
  });
};

exports.Default = Default;
Default.story = {
  name: 'Number Input'
};

var Playground = function Playground() {
  var _props = props(),
      numberInputArrowTranslationIds = _props.numberInputArrowTranslationIds,
      rest = (0, _objectWithoutProperties2.default)(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement(_NumberInput.default, (0, _extends2.default)({
    translateWithId: function translateWithId(id) {
      return numberInputArrowTranslationIds[id];
    }
  }, rest));
};

exports.Playground = Playground;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_NumberInput3.default, null);
};

exports.Skeleton = Skeleton;