"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationActionButton = NotificationActionButton;
exports.NotificationButton = NotificationButton;
exports.ToastNotification = ToastNotification;
exports.InlineNotification = InlineNotification;
exports.ActionableNotification = ActionableNotification;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../../Button"));

var _useIsomorphicEffect = _interopRequireDefault(require("../../../internal/useIsomorphicEffect"));

var _useNoInteractiveChildren = require("../../../internal/useNoInteractiveChildren");

var _keyboard = require("../../../internal/keyboard");

var _iconTypes;

var _excluded = ["children", "className", "onClick", "inline"],
    _excluded2 = ["ariaLabel", "className", "iconDescription", "type", "renderIcon", "name", "notificationType"],
    _excluded3 = ["role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "children", "kind", "lowContrast", "hideCloseButton", "timeout", "closeOnEscape"],
    _excluded4 = ["children", "role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "kind", "lowContrast", "hideCloseButton", "closeOnEscape"],
    _excluded5 = ["actionButtonLabel", "children", "role", "onActionButtonClick", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "inline", "kind", "lowContrast", "hideCloseButton", "hasFocus", "closeOnEscape"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;
/**
 * Conditionally call a callback when the escape key is pressed
 * @param {node} ref - ref of the container element to scope the functionality to
 * @param {func} callback - function to be called
 * @param {bool} override - escape hatch to conditionally call the callback
 */

function useEscapeToClose(ref, callback) {
  var override = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

  var handleKeyDown = function handleKeyDown(event) {
    // The callback should only be called when focus is on or within the container
    var elementContainsFocus = ref.current && document.activeElement === ref.current || ref.current.contains(document.activeElement);

    if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape]) && override && elementContainsFocus) {
      callback(event);
    }
  };

  (0, _useIsomorphicEffect.default)(function () {
    document.addEventListener('keydown', handleKeyDown, false);
    return function () {
      return document.removeEventListener('keydown', handleKeyDown, false);
    };
  });
}

function NotificationActionButton(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      onClick = _ref.onClick,
      inline = _ref.inline,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var className = (0, _classnames.default)(customClassName, (0, _defineProperty2.default)({}, "".concat(prefix, "--actionable-notification__action-button"), true));
  return /*#__PURE__*/_react.default.createElement(_Button.default, (0, _extends2.default)({
    className: className,
    kind: inline ? 'ghost' : 'tertiary',
    onClick: onClick,
    size: "sm"
  }, rest), children);
}

NotificationActionButton.propTypes = {
  /**
   * Specify the content of the notification action button.
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the notification action button
   */
  className: _propTypes.default.string,

  /**
   * Specify if the visual treatment of the button should be for an inline notification
   */
  inline: _propTypes.default.bool,

  /**
   * Optionally specify a click handler for the notification action button.
   */
  onClick: _propTypes.default.func
};

function NotificationButton(_ref2) {
  var ariaLabel = _ref2.ariaLabel,
      className = _ref2.className,
      iconDescription = _ref2.iconDescription,
      type = _ref2.type,
      IconTag = _ref2.renderIcon,
      name = _ref2.name,
      notificationType = _ref2.notificationType,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var buttonClassName = (0, _classnames.default)(className, (0, _defineProperty2.default)({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-button"), notificationType));
  var iconClassName = (0, _classnames.default)((0, _defineProperty2.default)({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-icon"), notificationType));
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, {
    // eslint-disable-next-line react/button-has-type
    type: type,
    "aria-label": iconDescription,
    title: iconDescription,
    className: buttonClassName
  }), IconTag && /*#__PURE__*/_react.default.createElement(IconTag, {
    "aria-label": ariaLabel,
    className: iconClassName,
    name: name
  }));
}

NotificationButton.propTypes = {
  /**
   * Specify a label to be read by screen readers on the notification button
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the notification button
   */
  className: _propTypes.default.string,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an optional icon for the Button through a string,
   * if something but regular "close" icon is desirable
   */
  name: _propTypes.default.string,

  /**
   * Specify the notification type
   */
  notificationType: _propTypes.default.oneOf(['toast', 'inline', 'actionable']),

  /**
   * Optional prop to allow overriding the icon rendering.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Optional prop to specify the type of the Button
   */
  type: _propTypes.default.string
};
NotificationButton.defaultProps = {
  ariaLabel: 'close notification',
  // TODO: deprecate this prop
  notificationType: 'toast',
  type: 'button',
  iconDescription: 'close icon',
  renderIcon: _iconsReact.Close20
};
var iconTypes = (_iconTypes = {
  error: _iconsReact.ErrorFilled20,
  success: _iconsReact.CheckmarkFilled20,
  warning: _iconsReact.WarningFilled20
}, (0, _defineProperty2.default)(_iconTypes, 'warning-alt', _iconsReact.WarningAltFilled20), (0, _defineProperty2.default)(_iconTypes, "info", _iconsReact.InformationFilled20), (0, _defineProperty2.default)(_iconTypes, 'info-square', _iconsReact.InformationSquareFilled20), _iconTypes);

function NotificationIcon(_ref3) {
  var iconDescription = _ref3.iconDescription,
      kind = _ref3.kind,
      notificationType = _ref3.notificationType;
  var IconForKind = iconTypes[kind];

  if (!IconForKind) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement(IconForKind, {
    className: "".concat(prefix, "--").concat(notificationType, "-notification__icon")
  }, /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
}

NotificationIcon.propTypes = {
  iconDescription: _propTypes.default.string.isRequired,
  kind: _propTypes.default.oneOf(['error', 'success', 'warning', 'warning-alt', 'info', 'info-square']).isRequired,
  notificationType: _propTypes.default.oneOf(['inline', 'toast']).isRequired
};

function ToastNotification(_ref4) {
  var _cx4;

  var role = _ref4.role,
      onClose = _ref4.onClose,
      onCloseButtonClick = _ref4.onCloseButtonClick,
      iconDescription = _ref4.iconDescription,
      statusIconDescription = _ref4.statusIconDescription,
      className = _ref4.className,
      children = _ref4.children,
      kind = _ref4.kind,
      lowContrast = _ref4.lowContrast,
      hideCloseButton = _ref4.hideCloseButton,
      timeout = _ref4.timeout,
      closeOnEscape = _ref4.closeOnEscape,
      rest = (0, _objectWithoutProperties2.default)(_ref4, _excluded3);

  var _useState = (0, _react.useState)(true),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var containerClassName = (0, _classnames.default)(className, (_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--toast-notification"), true), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--toast-notification--low-contrast"), lowContrast), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--toast-notification--").concat(kind), kind), _cx4));
  var contentRef = (0, _react.useRef)(null);
  (0, _useNoInteractiveChildren.useNoInteractiveChildren)(contentRef);

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  var ref = (0, _react.useRef)(null);
  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  var savedOnClose = (0, _react.useRef)(onClose);
  (0, _react.useEffect)(function () {
    savedOnClose.current = onClose;
  });
  (0, _react.useEffect)(function () {
    if (!timeout) {
      return;
    }

    var timeoutId = window.setTimeout(function (event) {
      setIsOpen(false);

      if (savedOnClose.current) {
        savedOnClose.current(event);
      }
    }, timeout);
    return function () {
      window.clearTimeout(timeoutId);
    };
  }, [timeout]);

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: ref
  }, rest, {
    role: role,
    className: containerClassName
  }), /*#__PURE__*/_react.default.createElement(NotificationIcon, {
    notificationType: "toast",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: contentRef,
    className: "".concat(prefix, "--toast-notification__content")
  }, children), !hideCloseButton && /*#__PURE__*/_react.default.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "toast",
    onClick: handleCloseButtonClick,
    "aria-hidden": "true"
  }));
}

ToastNotification.propTypes = {
  /**
   * Specify the content
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: _propTypes.default.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: _propTypes.default.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: _propTypes.default.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify what state the notification represents
   */
  kind: _propTypes.default.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the ToastNotification.
   */
  lowContrast: _propTypes.default.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: _propTypes.default.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side
   */
  role: _propTypes.default.oneOf(['alert', 'log', 'status']).isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: _propTypes.default.string,

  /**
   * Specify an optional duration the notification should be closed in
   */
  timeout: _propTypes.default.number
};
ToastNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  timeout: 0,
  closeOnEscape: true
};

function InlineNotification(_ref5) {
  var _cx5;

  var children = _ref5.children,
      role = _ref5.role,
      onClose = _ref5.onClose,
      onCloseButtonClick = _ref5.onCloseButtonClick,
      iconDescription = _ref5.iconDescription,
      statusIconDescription = _ref5.statusIconDescription,
      className = _ref5.className,
      kind = _ref5.kind,
      lowContrast = _ref5.lowContrast,
      hideCloseButton = _ref5.hideCloseButton,
      closeOnEscape = _ref5.closeOnEscape,
      rest = (0, _objectWithoutProperties2.default)(_ref5, _excluded4);

  var _useState3 = (0, _react.useState)(true),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1];

  var containerClassName = (0, _classnames.default)(className, (_cx5 = {}, (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--inline-notification"), true), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--inline-notification--low-contrast"), lowContrast), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--inline-notification--").concat(kind), kind), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--inline-notification--hide-close-button"), hideCloseButton), _cx5));
  var contentRef = (0, _react.useRef)(null);
  (0, _useNoInteractiveChildren.useNoInteractiveChildren)(contentRef);

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  var ref = (0, _react.useRef)(null);
  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: ref
  }, rest, {
    role: role,
    className: containerClassName
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-notification__details")
  }, /*#__PURE__*/_react.default.createElement(NotificationIcon, {
    notificationType: "inline",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-notification__text-wrapper")
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: contentRef,
    className: "".concat(prefix, "--inline-notification__content")
  }, children))), !hideCloseButton && /*#__PURE__*/_react.default.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "inline",
    onClick: handleCloseButtonClick,
    "aria-hidden": true
  }));
}

InlineNotification.propTypes = {
  /**
   * Specify the content
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: _propTypes.default.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: _propTypes.default.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: _propTypes.default.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify what state the notification represents
   */
  kind: _propTypes.default.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the InlineNotification.
   */
  lowContrast: _propTypes.default.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: _propTypes.default.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side. If the `actions` prop is
   * configured, this will be overridden to "alertdialog".
   */
  role: _propTypes.default.oneOf(['alert', 'log', 'status']).isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: _propTypes.default.string
};
InlineNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  closeOnEscape: true
};

function ActionableNotification(_ref6) {
  var _cx6;

  var actionButtonLabel = _ref6.actionButtonLabel,
      children = _ref6.children,
      role = _ref6.role,
      onActionButtonClick = _ref6.onActionButtonClick,
      onClose = _ref6.onClose,
      onCloseButtonClick = _ref6.onCloseButtonClick,
      iconDescription = _ref6.iconDescription,
      statusIconDescription = _ref6.statusIconDescription,
      className = _ref6.className,
      inline = _ref6.inline,
      kind = _ref6.kind,
      lowContrast = _ref6.lowContrast,
      hideCloseButton = _ref6.hideCloseButton,
      hasFocus = _ref6.hasFocus,
      closeOnEscape = _ref6.closeOnEscape,
      rest = (0, _objectWithoutProperties2.default)(_ref6, _excluded5);

  var _useState5 = (0, _react.useState)(true),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      isOpen = _useState6[0],
      setIsOpen = _useState6[1];

  var containerClassName = (0, _classnames.default)(className, (_cx6 = {}, (0, _defineProperty2.default)(_cx6, "".concat(prefix, "--actionable-notification"), true), (0, _defineProperty2.default)(_cx6, "".concat(prefix, "--actionable-notification--toast"), !inline), (0, _defineProperty2.default)(_cx6, "".concat(prefix, "--actionable-notification--low-contrast"), lowContrast), (0, _defineProperty2.default)(_cx6, "".concat(prefix, "--actionable-notification--").concat(kind), kind), (0, _defineProperty2.default)(_cx6, "".concat(prefix, "--actionable-notification--hide-close-button"), hideCloseButton), _cx6));
  var ref = (0, _react.useRef)(null);
  (0, _useIsomorphicEffect.default)(function () {
    if (ref.current && hasFocus) {
      ref.current.focus();
    }
  });

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    ref: ref,
    role: role,
    className: containerClassName
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__details")
  }, /*#__PURE__*/_react.default.createElement(NotificationIcon, {
    notificationType: inline ? 'inline' : 'toast',
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__text-wrapper")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__content")
  }, children))), /*#__PURE__*/_react.default.createElement(NotificationActionButton, {
    onClick: onActionButtonClick,
    inline: inline
  }, actionButtonLabel), !hideCloseButton && /*#__PURE__*/_react.default.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "actionable",
    onClick: handleCloseButtonClick,
    "aria-hidden": true
  }));
}

ActionableNotification.propTypes = {
  /**
   * Pass in the action button label that will be rendered within the ActionableNotification.
   */
  actionButtonLabel: _propTypes.default.string.isRequired,

  /**
   * Specify the content
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: _propTypes.default.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: _propTypes.default.bool,

  /**
   * Specify if focus should be moved to the component when the notification contains actions
   */
  hasFocus: _propTypes.default.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: _propTypes.default.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /*
   * Specify if the notification should have inline styling applied instead of toast
   */
  inline: _propTypes.default.bool,

  /**
   * Specify what state the notification represents
   */
  kind: _propTypes.default.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the ActionableNotification.
   */
  lowContrast: _propTypes.default.bool,

  /**
   * Provide a function that is called when the action is clicked
   */
  onActionButtonClick: _propTypes.default.func,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: _propTypes.default.func,

  /**
   * By default, this value is "alertdialog". You can also provide an alternate
   * role if it makes sense from the accessibility-side.
   */
  role: _propTypes.default.string,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: _propTypes.default.string
};
ActionableNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'alertdialog',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  hasFocus: true,
  closeOnEscape: true,
  inline: false
};