"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _Notification = require("../next/Notification");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

var _carbonComponents = require("carbon-components");

var _windowOrGlobal = require("window-or-global");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('NotificationButton', function () {
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
      className: "test"
    })),
        container = _render.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('renders only one icon', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null));
    expect(_react2.screen.queryAllByRole('img').length).toEqual(1);
  });
  (0, _windowOrGlobal.it)('supports custom icon', function () {
    var _render2 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null)),
        rerender = _render2.rerender;

    var defaultIcon = _react2.screen.queryByRole('img').innerHTML;

    rerender( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
      renderIcon: _iconsReact.ErrorFilled20
    }));

    var customIcon = _react2.screen.queryByRole('img').innerHTML;

    expect(defaultIcon).not.toEqual(customIcon);
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on notificationType prop', function () {
    var _render3 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null)),
        rerender = _render3.rerender,
        container = _render3.container;

    var notificationTypes = ['toast', 'inline'];
    notificationTypes.forEach(function (notificationType) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
        notificationType: notificationType
      }));
      expect(container.firstChild).toHaveClass("".concat(prefix, "--").concat(notificationType, "-notification__close-button"));
      expect(_react2.screen.queryByRole('img')).toHaveClass("".concat(prefix, "--").concat(notificationType, "-notification__close-icon"));
    });
  });
});
describe('ToastNotification', function () {
  (0, _windowOrGlobal.it)('should have role=status by default', function () {
    var _render4 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null)),
        container = _render4.container;

    expect(container.firstChild).toHaveAttribute('role', 'status');
  });
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render5 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      className: "test"
    })),
        container = _render5.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on kind prop', function () {
    var _render6 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null)),
        rerender = _render6.rerender;

    var kinds = ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'];
    kinds.forEach(function (kind) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
        kind: kind
      }));
      expect(_react2.screen.queryByRole('status')).toHaveClass("".concat(prefix, "--toast-notification--").concat(kind));
    });
  });
  (0, _windowOrGlobal.it)('allows non-interactive elements as children', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null, /*#__PURE__*/_react.default.createElement("p", null, "Sample text")));
    expect(_react2.screen.queryByText(/Sample text/i)).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('does not allow interactive elements as children', function () {
    var spy = jest.spyOn(console, 'error').mockImplementation(function () {});
    expect(function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null, /*#__PURE__*/_react.default.createElement("button", {
        type: "button"
      }, "Sample button text")));
    }).toThrow();
    expect(spy).toHaveBeenCalled();
    spy.mockRestore();
  });
  (0, _windowOrGlobal.it)('close button is rendered by default and includes aria-hidden=true', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).toBeInTheDocument();
    expect(closeButton).toHaveAttribute('aria-hidden', 'true');
  });
  (0, _windowOrGlobal.it)('does not render close button when `hideCloseButton` is provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      hideCloseButton: true
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).not.toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onClose` when notification is closed', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
    var onClose, closeButton;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
              onClose: onClose
            }));
            closeButton = _react2.screen.queryByRole('button', {
              hidden: true
            });

            _userEvent.default.click(closeButton);

            expect(onClose).toHaveBeenCalledTimes(1);
            _context.next = 7;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 7:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  (0, _windowOrGlobal.it)('keeps notification open if `onClose` returns false', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      onClose: function onClose() {
        return false;
      }
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(_react2.screen.queryByRole('status')).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onCloseButtonClick` when notification is closed', function () {
    var onCloseButtonClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      onCloseButtonClick: onCloseButtonClick
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
  });
  (0, _windowOrGlobal.it)('closes notification via escape button', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
    var onCloseButtonClick, onClose;
    return _regenerator.default.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            onCloseButtonClick = jest.fn();
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
              onClose: onClose,
              onCloseButtonClick: onCloseButtonClick
            })); // without focus being on/in the notification, it should not close via escape

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(0);
            expect(onClose).toHaveBeenCalledTimes(0); // after focus is placed, the notification should close via escape

            _userEvent.default.tab();

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
            expect(onClose).toHaveBeenCalledTimes(1);
            _context2.next = 12;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 12:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
});
describe('InlineNotification', function () {
  (0, _windowOrGlobal.it)('should have role=status by default', function () {
    var _render7 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null)),
        container = _render7.container;

    expect(container.firstChild).toHaveAttribute('role', 'status');
  });
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render8 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      className: "test"
    })),
        container = _render8.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on kind prop', function () {
    var _render9 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null)),
        rerender = _render9.rerender;

    var kinds = ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'];
    kinds.forEach(function (kind) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
        kind: kind
      }));
      expect(_react2.screen.queryByRole('status')).toHaveClass("".concat(prefix, "--inline-notification--").concat(kind));
    });
  });
  (0, _windowOrGlobal.it)('allows non-interactive elements as children', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null, /*#__PURE__*/_react.default.createElement("p", null, "Sample text")));
    expect(_react2.screen.queryByText(/Sample text/i)).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('does not allow interactive elements as children', function () {
    var spy = jest.spyOn(console, 'error').mockImplementation(function () {});
    expect(function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null, /*#__PURE__*/_react.default.createElement("button", {
        type: "button"
      }, "Sample button text")));
    }).toThrow();
    expect(spy).toHaveBeenCalled();
    spy.mockRestore();
  });
  (0, _windowOrGlobal.it)('close button is rendered by default and includes aria-hidden=true', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).toBeInTheDocument();
    expect(closeButton).toHaveAttribute('aria-hidden', 'true');
  });
  (0, _windowOrGlobal.it)('does not render close button when `hideCloseButton` is provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      hideCloseButton: true
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).not.toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onClose` when notification is closed', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
    var onClose, closeButton;
    return _regenerator.default.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
              onClose: onClose
            }));
            closeButton = _react2.screen.queryByRole('button', {
              hidden: true
            });

            _userEvent.default.click(closeButton);

            expect(onClose).toHaveBeenCalledTimes(1);
            _context3.next = 7;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 7:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  })));
  (0, _windowOrGlobal.it)('keeps notification open if `onClose` returns false', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      onClose: function onClose() {
        return false;
      }
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(_react2.screen.queryByRole('status')).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onCloseButtonClick` when notification is closed', function () {
    var onCloseButtonClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      onCloseButtonClick: onCloseButtonClick
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
  });
  (0, _windowOrGlobal.it)('closes notification via escape button', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
    var onCloseButtonClick, onClose;
    return _regenerator.default.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            onCloseButtonClick = jest.fn();
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
              onClose: onClose,
              onCloseButtonClick: onCloseButtonClick
            })); // without focus being on/in the notification, it should not close via escape

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(0);
            expect(onClose).toHaveBeenCalledTimes(0); // after focus is placed, the notification should close via escape

            _userEvent.default.tab();

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
            expect(onClose).toHaveBeenCalledTimes(1);
            _context4.next = 12;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 12:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  })));
});
describe('ActionableNotification', function () {
  (0, _windowOrGlobal.it)('uses role=alertdialog', function () {
    var _render10 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ActionableNotification, {
      actionButtonLabel: "My custom action"
    })),
        container = _render10.container;

    expect(container.firstChild).toHaveAttribute('role', 'alertdialog');
  });
  (0, _windowOrGlobal.it)('renders correct action label', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ActionableNotification, {
      actionButtonLabel: "My custom action"
    }));

    var actionButton = _react2.screen.queryByRole('button', {
      name: 'My custom action'
    });

    expect(actionButton).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('closes notification via escape button when focus is placed on the notification', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5() {
    var onCloseButtonClick, onClose;
    return _regenerator.default.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            onCloseButtonClick = jest.fn();
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ActionableNotification, {
              onClose: onClose,
              onCloseButtonClick: onCloseButtonClick,
              actionButtonLabel: "My custom action"
            })); // without focus being on/in the notification, it should not close via escape

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(0);
            expect(onClose).toHaveBeenCalledTimes(0); // after focus is placed, the notification should close via escape

            _userEvent.default.tab();

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
            expect(onClose).toHaveBeenCalledTimes(1);
            _context5.next = 12;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('alertdialog')).not.toBeInTheDocument();
            });

          case 12:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  })));
});