"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Inline = exports.Toast = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Notification = require("../Notification");

var _Notification2 = _interopRequireDefault(require("./Notification.mdx"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var kinds = {
  'Error (error)': 'error',
  'Info (info)': 'info',
  'Info square (info-square)': 'info-square',
  'Success (success)': 'success',
  'Warning (warning)': 'warning',
  'Warning (warning-alt)': 'warning-alt'
};

var notificationProps = function notificationProps() {
  return {
    kind: (0, _addonKnobs.select)('The notification kind (kind)', kinds, 'info'),
    lowContrast: (0, _addonKnobs.boolean)('Use low contrast variant (lowContrast)', false),
    role: (0, _addonKnobs.text)('ARIA role (role)', 'alert'),
    title: (0, _addonKnobs.text)('Title (title)', 'Notification title'),
    subtitle: (0, _addonKnobs.text)('Subtitle (subtitle)', 'Subtitle text goes here.'),
    iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', 'describes the close button'),
    statusIconDescription: (0, _addonKnobs.text)('Status icon description (statusIconDescription)', 'describes the status icon'),
    hideCloseButton: (0, _addonKnobs.boolean)('Hide close button (hideCloseButton)', false),
    onClose: (0, _addonActions.action)('onClose'),
    onCloseButtonClick: (0, _addonActions.action)('onCloseButtonClick')
  };
};

var toastNotificationProps = function toastNotificationProps() {
  return _objectSpread(_objectSpread({}, notificationProps()), {}, {
    timeout: (0, _addonKnobs.number)('Duration in milliseconds to display notification (timeout)', 0)
  });
};

var _default = {
  title: 'Components/Notifications',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Notification2.default
    },
    subcomponents: {
      ToastNotification: _Notification.ToastNotification,
      InlineNotification: _Notification.InlineNotification
    }
  }
};
exports.default = _default;

var Toast = function Toast() {
  return /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, (0, _extends2.default)({}, toastNotificationProps(), {
    caption: (0, _addonKnobs.text)('Caption (caption)', '00:00:00 AM'),
    style: {
      marginBottom: '.5rem'
    }
  }));
};

exports.Toast = Toast;

var Inline = function Inline() {
  return /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, (0, _extends2.default)({}, notificationProps(), {
    actions: /*#__PURE__*/_react.default.createElement(_Notification.NotificationActionButton, {
      onClick: (0, _addonActions.action)('NotificationActionButton onClick')
    }, (0, _addonKnobs.text)('Action (NotificationActionButton > children)', 'Action'))
  }));
};

exports.Inline = Inline;
Inline.storyName = 'inline';