"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _downshift = _interopRequireDefault(require("downshift"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _filter = require("../../ComboBox/tools/filter");

var _MultiSelectPropTypes = require("../MultiSelectPropTypes");

var _ListBox = _interopRequireWildcard(require("../../ListBox"));

var _next = require("../../ListBox/next");

var _keyboard = require("../../../internal/keyboard");

var _Selection = _interopRequireDefault(require("../../../internal/Selection"));

var _createPropAdapter = require("../../../tools/createPropAdapter");

var _itemToString = require("../tools/itemToString");

var _mergeRefs = _interopRequireDefault(require("../../../tools/mergeRefs"));

var _useId = require("../../../internal/useId");

var _sorting = require("../tools/sorting");

var _FeatureFlags = require("../../FeatureFlags");

var _usePrefix = require("../../../internal/usePrefix");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var FilterableMultiSelect = /*#__PURE__*/_react.default.forwardRef(function FilterableMultiSelect(_ref, ref) {
  var _cx, _cx2, _cx3, _cx4;

  var ariaLabel = _ref.ariaLabel,
      containerClassName = _ref.className,
      compareItems = _ref.compareItems,
      direction = _ref.direction,
      disabled = _ref.disabled,
      downshiftProps = _ref.downshiftProps,
      filterItems = _ref.filterItems,
      helperText = _ref.helperText,
      hideLabel = _ref.hideLabel,
      id = _ref.id,
      initialSelectedItems = _ref.initialSelectedItems,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      items = _ref.items,
      ItemToElement = _ref.itemToElement,
      itemToString = _ref.itemToString,
      light = _ref.light,
      locale = _ref.locale,
      open = _ref.open,
      onChange = _ref.onChange,
      onMenuChange = _ref.onMenuChange,
      placeholder = _ref.placeholder,
      titleText = _ref.titleText,
      type = _ref.type,
      selectionFeedback = _ref.selectionFeedback,
      size = _ref.size,
      sortItems = _ref.sortItems,
      translateWithId = _ref.translateWithId,
      useTitleInItem = _ref.useTitleInItem,
      warn = _ref.warn,
      warnText = _ref.warnText;

  var _useState = (0, _react.useState)(open),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(open),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevOpen = _useState4[0],
      setPrevOpen = _useState4[1];

  var _useState5 = (0, _react.useState)(''),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      inputValue = _useState6[0],
      setInputValue = _useState6[1];

  var _useState7 = (0, _react.useState)([]),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      topItems = _useState8[0],
      setTopItems = _useState8[1];

  var _useState9 = (0, _react.useState)(false),
      _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
      inputFocused = _useState10[0],
      setInputFocused = _useState10[1];

  var _useState11 = (0, _react.useState)(null),
      _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
      highlightedIndex = _useState12[0],
      setHighlightedIndex = _useState12[1];

  var textInput = (0, _react.useRef)();
  var filterableMultiSelectInstanceId = (0, _useId.useId)();
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var prefix = (0, _usePrefix.usePrefix)();

  if (prevOpen !== open) {
    setIsOpen(open);
    setPrevOpen(open);
  }

  var inline = type === 'inline';
  var showWarning = !invalid && warn;
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--multi-select__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx));
  var helperId = !helperText ? undefined : "filterablemultiselect-helper-text-".concat(filterableMultiSelectInstanceId);
  var labelId = "".concat(id, "-label");
  var titleClasses = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label--disabled"), disabled), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
  var helperClasses = (0, _classnames.default)((_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--form__helper-text"), true), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--form__helper-text--disabled"), disabled), _cx3));
  var inputClasses = (0, _classnames.default)((_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input"), true), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input--empty"), !inputValue), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input--light"), light), _cx4));
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    id: helperId,
    className: helperClasses
  }, helperText) : null;
  var menuId = "".concat(id, "__menu");
  var inputId = "".concat(id, "-input");

  function handleOnChange(changes) {
    if (onChange) {
      onChange(changes);
    }
  }

  function handleOnMenuChange(forceIsOpen) {
    var nextIsOpen = forceIsOpen !== null && forceIsOpen !== void 0 ? forceIsOpen : !isOpen;
    setIsOpen(nextIsOpen);

    if (onMenuChange) {
      onMenuChange(nextIsOpen);
    }
  }

  function handleOnOuterClick() {
    handleOnMenuChange(false);
  }

  function handleOnStateChange(changes, downshift) {
    if (changes.isOpen && !isOpen) {
      setTopItems(downshift.selectedItem);
    }

    var type = changes.type;
    var stateChangeTypes = _downshift.default.stateChangeTypes;

    switch (type) {
      case stateChangeTypes.keyDownArrowDown:
      case stateChangeTypes.keyDownArrowUp:
      case stateChangeTypes.keyDownHome:
      case stateChangeTypes.keyDownEnd:
        setHighlightedIndex(changes.highlightedIndex !== undefined ? changes.highlightedIndex : null);

        if (stateChangeTypes.keyDownArrowDown === type && !isOpen) {
          handleOnMenuChange(true);
        }

        break;

      case stateChangeTypes.keyDownEscape:
        handleOnMenuChange(false);
        break;
    }
  }

  function handleOnInputValueChange(inputValue, _ref2) {
    var type = _ref2.type;

    if (type !== _downshift.default.stateChangeTypes.changeInput) {
      return;
    }

    if (Array.isArray(inputValue)) {
      clearInputValue();
    } else {
      setInputValue(inputValue);
    }

    if (inputValue && !isOpen) {
      handleOnMenuChange(true);
    } else if (!inputValue && isOpen) {
      handleOnMenuChange(false);
    }
  }

  function clearInputValue() {
    setInputValue('');

    if (textInput.current) {
      textInput.current.focus();
    }
  }

  return /*#__PURE__*/_react.default.createElement(_Selection.default, {
    disabled: disabled,
    onChange: handleOnChange,
    initialSelectedItems: initialSelectedItems,
    render: function render(_ref3) {
      var selectedItems = _ref3.selectedItems,
          onItemChange = _ref3.onItemChange,
          _clearSelection = _ref3.clearSelection;
      return /*#__PURE__*/_react.default.createElement(_downshift.default, (0, _extends2.default)({}, (0, _createPropAdapter.mapDownshiftProps)(downshiftProps), {
        highlightedIndex: highlightedIndex,
        id: id,
        isOpen: isOpen,
        inputValue: inputValue,
        onInputValueChange: handleOnInputValueChange,
        onChange: function onChange(selectedItem) {
          if (selectedItem !== null) {
            onItemChange(selectedItem);
          }
        },
        itemToString: itemToString,
        onStateChange: handleOnStateChange,
        onOuterClick: handleOnOuterClick,
        selectedItem: selectedItems,
        labelId: labelId,
        menuId: menuId,
        inputId: inputId
      }), function (_ref4) {
        var _cx5;

        var getInputProps = _ref4.getInputProps,
            getItemProps = _ref4.getItemProps,
            getLabelProps = _ref4.getLabelProps,
            getMenuProps = _ref4.getMenuProps,
            getRootProps = _ref4.getRootProps,
            getToggleButtonProps = _ref4.getToggleButtonProps,
            isOpen = _ref4.isOpen,
            inputValue = _ref4.inputValue,
            selectedItem = _ref4.selectedItem;
        var className = (0, _classnames.default)("".concat(prefix, "--multi-select"), "".concat(prefix, "--combo-box"), "".concat(prefix, "--multi-select--filterable"), [enabled ? null : containerClassName], (_cx5 = {}, (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--invalid"), invalid), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--open"), isOpen), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--inline"), inline), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--selected"), selectedItem.length > 0), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--filterable--input-focused"), inputFocused), _cx5));
        var rootProps = getRootProps({}, {
          suppressRefError: true
        });
        var labelProps = getLabelProps();
        var buttonProps = getToggleButtonProps({
          disabled: disabled,
          onClick: function onClick() {
            handleOnMenuChange(!isOpen);

            if (textInput.current) {
              textInput.current.focus();
            }
          },
          // When we moved the "root node" of Downshift to the <input> for
          // ARIA 1.2 compliance, we unfortunately hit this branch for the
          // "mouseup" event that downshift listens to:
          // https://github.com/downshift-js/downshift/blob/v5.2.1/src/downshift.js#L1051-L1065
          //
          // As a result, it will reset the state of the component and so we
          // stop the event from propagating to prevent this. This allows the
          // toggleMenu behavior for the toggleButton to correctly open and
          // close the menu.
          onMouseUp: function onMouseUp(event) {
            event.stopPropagation();
          }
        });
        var inputProps = getInputProps({
          'aria-controls': isOpen ? menuId : null,
          'aria-describedby': helperText ? helperId : null,
          // Remove excess aria `aria-labelledby`. HTML <label for>
          // provides this aria information.
          'aria-labelledby': null,
          disabled: disabled,
          placeholder: placeholder,
          onClick: function onClick() {
            handleOnMenuChange(true);
          },
          onKeyDown: function onKeyDown(event) {
            if ((0, _keyboard.match)(event, _keyboard.keys.Space)) {
              event.stopPropagation();
            }
          },
          onFocus: function onFocus() {
            setInputFocused(true);
          },
          onBlur: function onBlur() {
            setInputFocused(false);
          }
        });
        var menuProps = getMenuProps({
          'aria-label': ariaLabel
        }, {
          suppressRefError: true
        });
        return /*#__PURE__*/_react.default.createElement("div", {
          className: wrapperClasses
        }, titleText ? /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
          className: titleClasses
        }, labelProps), titleText) : null, /*#__PURE__*/_react.default.createElement(_ListBox.default, {
          className: className,
          disabled: disabled,
          light: light,
          ref: ref,
          invalid: invalid,
          invalidText: invalidText,
          warn: warn,
          warnText: warnText,
          isOpen: isOpen,
          size: size
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--list-box__field")
        }, selectedItem.length > 0 && /*#__PURE__*/_react.default.createElement(_next.ListBoxSelection, {
          clearSelection: function clearSelection() {
            _clearSelection();

            if (textInput.current) {
              textInput.current.focus();
            }
          },
          selectionCount: selectedItem.length,
          translateWithId: translateWithId,
          disabled: disabled
        }), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
          className: inputClasses
        }, rootProps, inputProps, {
          ref: (0, _mergeRefs.default)(textInput, rootProps.ref)
        })), invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
          className: "".concat(prefix, "--list-box__invalid-icon")
        }), showWarning && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
          className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
        }), inputValue && /*#__PURE__*/_react.default.createElement(_next.ListBoxSelection, {
          clearSelection: clearInputValue,
          disabled: disabled,
          translateWithId: translateWithId,
          onMouseUp: function onMouseUp(event) {
            // If we do not stop this event from propagating,
            // it seems like Downshift takes our event and
            // prevents us from getting `onClick` /
            // `clearSelection` from the underlying <button> in
            // ListBoxSelection
            event.stopPropagation();
          }
        }), /*#__PURE__*/_react.default.createElement(_next.ListBoxTrigger, (0, _extends2.default)({}, buttonProps, {
          isOpen: isOpen,
          translateWithId: translateWithId
        }))), isOpen ? /*#__PURE__*/_react.default.createElement(_ListBox.default.Menu, menuProps, sortItems(filterItems(items, {
          itemToString: itemToString,
          inputValue: inputValue
        }), {
          selectedItems: {
            top: selectedItems,
            fixed: [],
            'top-after-reopen': topItems
          }[selectionFeedback],
          itemToString: itemToString,
          compareItems: compareItems,
          locale: locale
        }).map(function (item, index) {
          var itemProps = getItemProps({
            item: item,
            disabled: item.disabled
          });
          var itemText = itemToString(item);
          var isChecked = selectedItem.filter(function (selected) {
            return (0, _lodash.default)(selected, item);
          }).length > 0;
          return /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuItem, (0, _extends2.default)({
            key: itemProps.id,
            "aria-label": itemText,
            isActive: isChecked,
            isHighlighted: highlightedIndex === index,
            title: itemText
          }, itemProps), /*#__PURE__*/_react.default.createElement("div", {
            className: "".concat(prefix, "--checkbox-wrapper")
          }, /*#__PURE__*/_react.default.createElement("span", {
            title: useTitleInItem ? itemText : null,
            className: "".concat(prefix, "--checkbox-label"),
            "data-contained-checkbox-state": isChecked,
            id: "".concat(itemProps.id, "-item")
          }, ItemToElement ? /*#__PURE__*/_react.default.createElement(ItemToElement, (0, _extends2.default)({
            key: itemProps.id
          }, item)) : itemText)));
        })) : null), !inline && !invalid && !warn ? helper : null);
      });
    }
  });
});

FilterableMultiSelect.propTypes = _objectSpread(_objectSpread({
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify the direction of the multiselect dropdown. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: _propTypes.default.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: _propTypes.default.shape(_downshift.default.propTypes),

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Allow users to pass in arbitrary items from their collection that are
   * pre-selected
   */
  initialSelectedItems: _propTypes.default.array,

  /**
   * Is the current selection invalid?
   */
  invalid: _propTypes.default.bool,

  /**
   * If invalid, what is the error?
   */
  invalidText: _propTypes.default.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: _propTypes.default.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: _propTypes.default.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes.default.array.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * Specify the locale of the control. Used for the default `compareItems`
   * used for sorting the list of items in the control.
   */
  locale: _propTypes.default.string,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: _propTypes.default.func,

  /**
   * `onMenuChange` is a utility for this controlled component to communicate to a
   * consuming component that the menu was opened(`true`)/closed(`false`).
   */
  onMenuChange: _propTypes.default.func,

  /**
   * Initialize the component with an open(`true`)/closed(`false`) menu.
   */
  open: _propTypes.default.bool,

  /**
   * Generic `placeholder` that will be used as the textual representation of
   * what this field is for
   */
  placeholder: _propTypes.default.string.isRequired,

  /**
   * Specify feedback (mode) of the selection.
   * `top`: selected item jumps to top
   * `fixed`: selected item stays at it's position
   * `top-after-reopen`: selected item jump to top after reopen dropdown
   */
  selectionFeedback: _propTypes.default.oneOf(['top', 'fixed', 'top-after-reopen']),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBox.PropTypes.ListBoxSize
}, _MultiSelectPropTypes.sortingPropTypes), {}, {
  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: _propTypes.default.func,

  /**
   * Specify title to show title on hover
   */
  useTitleInItem: _propTypes.default.bool,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});
FilterableMultiSelect.defaultProps = {
  ariaLabel: 'Choose an item',
  compareItems: _sorting.defaultCompareItems,
  direction: 'bottom',
  disabled: false,
  filterItems: _filter.defaultFilterItems,
  initialSelectedItems: [],
  itemToString: _itemToString.defaultItemToString,
  locale: 'en',
  sortItems: _sorting.defaultSortItems,
  light: false,
  open: false,
  selectionFeedback: 'top-after-reopen'
};
var _default = FilterableMultiSelect;
exports.default = _default;