"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _downshift = _interopRequireWildcard(require("downshift"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _ListBox = _interopRequireWildcard(require("../ListBox"));

var _MultiSelectPropTypes = require("./MultiSelectPropTypes");

var _itemToString2 = require("./tools/itemToString");

var _sorting = require("./tools/sorting");

var _Selection = require("../../internal/Selection");

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _createPropAdapter = require("../../tools/createPropAdapter");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _keyboard = require("../../internal/keyboard");

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var noop = function noop() {};

var getInstanceId = (0, _setupGetInstanceId.default)();
var _useSelect$stateChang = _downshift.useSelect.stateChangeTypes,
    ItemClick = _useSelect$stateChang.ItemClick,
    MenuBlur = _useSelect$stateChang.MenuBlur,
    MenuKeyDownArrowDown = _useSelect$stateChang.MenuKeyDownArrowDown,
    MenuKeyDownArrowUp = _useSelect$stateChang.MenuKeyDownArrowUp,
    MenuKeyDownEnter = _useSelect$stateChang.MenuKeyDownEnter,
    MenuKeyDownEscape = _useSelect$stateChang.MenuKeyDownEscape,
    MenuKeyDownSpaceButton = _useSelect$stateChang.MenuKeyDownSpaceButton,
    ToggleButtonClick = _useSelect$stateChang.ToggleButtonClick;

var MultiSelect = /*#__PURE__*/_react.default.forwardRef(function MultiSelect(_ref, ref) {
  var _cx, _cx2, _cx4;

  var containerClassName = _ref.className,
      id = _ref.id,
      items = _ref.items,
      itemToElement = _ref.itemToElement,
      _itemToString = _ref.itemToString,
      titleText = _ref.titleText,
      hideLabel = _ref.hideLabel,
      helperText = _ref.helperText,
      label = _ref.label,
      type = _ref.type,
      size = _ref.size,
      disabled = _ref.disabled,
      initialSelectedItems = _ref.initialSelectedItems,
      sortItems = _ref.sortItems,
      compareItems = _ref.compareItems,
      clearSelectionText = _ref.clearSelectionText,
      clearSelectionDescription = _ref.clearSelectionDescription,
      light = _ref.light,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      useTitleInItem = _ref.useTitleInItem,
      translateWithId = _ref.translateWithId,
      downshiftProps = _ref.downshiftProps,
      open = _ref.open,
      selectionFeedback = _ref.selectionFeedback,
      onChange = _ref.onChange,
      onMenuChange = _ref.onMenuChange,
      direction = _ref.direction,
      selected = _ref.selectedItems;
  var prefix = (0, _usePrefix.usePrefix)();

  var _useRef = (0, _react.useRef)(getInstanceId()),
      multiSelectInstanceId = _useRef.current;

  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      highlightedIndex = _useState2[0],
      setHighlightedIndex = _useState2[1];

  var _useState3 = (0, _react.useState)(open),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1];

  var _useState5 = (0, _react.useState)(open),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      prevOpenProp = _useState6[0],
      setPrevOpenProp = _useState6[1];

  var _useState7 = (0, _react.useState)([]),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      topItems = _useState8[0],
      setTopItems = _useState8[1];

  var _useSelection = (0, _Selection.useSelection)({
    disabled: disabled,
    initialSelectedItems: initialSelectedItems,
    onChange: onChange,
    selectedItems: selected
  }),
      controlledSelectedItems = _useSelection.selectedItems,
      onItemChange = _useSelection.onItemChange,
      clearSelection = _useSelection.clearSelection;

  var _useSelect = (0, _downshift.useSelect)((0, _createPropAdapter.mapDownshiftProps)(_objectSpread(_objectSpread({}, downshiftProps), {}, {
    highlightedIndex: highlightedIndex,
    isOpen: isOpen,
    itemToString: function itemToString(items) {
      return items.map(function (item) {
        return _itemToString(item);
      }).join(', ');
    },
    onStateChange: onStateChange,
    selectedItem: controlledSelectedItems,
    items: items
  }))),
      getToggleButtonProps = _useSelect.getToggleButtonProps,
      getLabelProps = _useSelect.getLabelProps,
      getMenuProps = _useSelect.getMenuProps,
      getItemProps = _useSelect.getItemProps,
      selectedItems = _useSelect.selectedItem;
  /**
   * wrapper function to forward changes to consumer
   */


  var setIsOpenWrapper = function setIsOpenWrapper(open) {
    setIsOpen(open);

    if (onMenuChange) {
      onMenuChange(open);
    }
  };
  /**
   * programmatically control this `open` prop
   */


  if (prevOpenProp !== open) {
    setIsOpenWrapper(open);
    setPrevOpenProp(open);
  }

  var inline = type === 'inline';
  var showWarning = !invalid && warn;
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--multi-select__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx));
  var titleClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label--disabled"), disabled), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
  var helperId = !helperText ? undefined : "multiselect-helper-text-".concat(multiSelectInstanceId);
  var fieldLabelId = "multiselect-field-label-".concat(multiSelectInstanceId);
  var helperClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var className = (0, _classnames.default)("".concat(prefix, "--multi-select"), [enabled ? null : containerClassName], (_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--multi-select--invalid"), invalid), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--multi-select--warning"), showWarning), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--multi-select--inline"), inline), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--multi-select--selected"), selectedItems && selectedItems.length > 0), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx4)); // needs to be capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  var sortOptions = {
    selectedItems: controlledSelectedItems,
    itemToString: _itemToString,
    compareItems: compareItems,
    locale: 'en'
  };

  if (selectionFeedback === 'fixed') {
    sortOptions.selectedItems = [];
  } else if (selectionFeedback === 'top-after-reopen') {
    sortOptions.selectedItems = topItems;
  }

  function onStateChange(changes) {
    if (changes.isOpen && !isOpen) {
      setTopItems(controlledSelectedItems);
    }

    var type = changes.type;

    switch (type) {
      case ItemClick:
      case MenuKeyDownSpaceButton:
      case MenuKeyDownEnter:
        if (changes.selectedItem === undefined) {
          break;
        }

        onItemChange(changes.selectedItem);
        break;

      case MenuKeyDownArrowDown:
      case MenuKeyDownArrowUp:
        setHighlightedIndex(changes.highlightedIndex);
        break;

      case MenuBlur:
      case MenuKeyDownEscape:
        setIsOpenWrapper(false);
        setHighlightedIndex(changes.highlightedIndex);
        break;

      case ToggleButtonClick:
        setIsOpenWrapper(changes.isOpen || false);
        setHighlightedIndex(changes.highlightedIndex);
        break;
    }
  }

  var onKeyDown = function onKeyDown(e) {
    if ((0, _keyboard.match)(e, _keyboard.keys.Delete) && !disabled) {
      clearSelection();
      e.stopPropagation();
    }
  };

  var toggleButtonProps = getToggleButtonProps();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
    className: titleClasses
  }, getLabelProps()), titleText && titleText, selectedItems.length > 0 && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--visually-hidden")
  }, clearSelectionDescription, " ", selectedItems.length, ",", clearSelectionText)), /*#__PURE__*/_react.default.createElement(_ListBox.default, {
    type: type,
    size: size,
    className: className,
    disabled: disabled,
    light: light,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText,
    isOpen: isOpen,
    id: id
  }, invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon")
  }), showWarning && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
  }), /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    className: "".concat(prefix, "--list-box__field"),
    disabled: disabled,
    "aria-disabled": disabled
  }, toggleButtonProps, {
    ref: (0, _mergeRefs.default)(toggleButtonProps.ref, ref),
    onKeyDown: onKeyDown
  }), selectedItems.length > 0 && /*#__PURE__*/_react.default.createElement(_ListBox.default.Selection, {
    clearSelection: !disabled ? clearSelection : noop,
    selectionCount: selectedItems.length,
    translateWithId: translateWithId,
    disabled: disabled
  }), /*#__PURE__*/_react.default.createElement("span", {
    id: fieldLabelId,
    className: "".concat(prefix, "--list-box__label")
  }, label), /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuIcon, {
    isOpen: isOpen,
    translateWithId: translateWithId
  })), /*#__PURE__*/_react.default.createElement(_ListBox.default.Menu, (0, _extends2.default)({
    "aria-multiselectable": "true"
  }, getMenuProps()), isOpen && sortItems(items, sortOptions).map(function (item, index) {
    var _getItemProps;

    var itemProps = getItemProps((_getItemProps = {
      item: item
    }, (0, _defineProperty2.default)(_getItemProps, 'aria-selected', isChecked ? true : null), (0, _defineProperty2.default)(_getItemProps, "disabled", item.disabled), _getItemProps));

    var itemText = _itemToString(item);

    var isChecked = selectedItems.filter(function (selected) {
      return (0, _lodash.default)(selected, item);
    }).length > 0;
    return /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuItem, (0, _extends2.default)({
      key: itemProps.id,
      isActive: isChecked,
      "aria-label": itemText,
      isHighlighted: highlightedIndex === index,
      title: itemText
    }, itemProps), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--checkbox-wrapper")
    }, /*#__PURE__*/_react.default.createElement("span", {
      title: useTitleInItem ? itemText : null,
      className: "".concat(prefix, "--checkbox-label"),
      "data-contained-checkbox-state": isChecked,
      id: "".concat(itemProps.id, "__checkbox")
    }, itemToElement ? /*#__PURE__*/_react.default.createElement(ItemToElement, (0, _extends2.default)({
      key: itemProps.id
    }, item)) : itemText)));
  }))), !inline && !invalid && !warn && helperText && /*#__PURE__*/_react.default.createElement("div", {
    id: helperId,
    className: helperClasses
  }, helperText));
});

MultiSelect.displayName = 'MultiSelect';
MultiSelect.propTypes = _objectSpread(_objectSpread({}, _MultiSelectPropTypes.sortingPropTypes), {}, {
  /**
   * Specify the text that should be read for screen readers that describes total items selected
   */
  clearSelectionDescription: _propTypes.default.string,

  /**
   * Specify the text that should be read for screen readers to clear selection.
   */
  clearSelectionText: _propTypes.default.string,

  /**
   * Specify the direction of the multiselect dropdown. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: _propTypes.default.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: _propTypes.default.shape(_downshift.default.propTypes),

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Allow users to pass in arbitrary items from their collection that are
   * pre-selected
   */
  initialSelectedItems: _propTypes.default.array,

  /**
   * Is the current selection invalid?
   */
  invalid: _propTypes.default.bool,

  /**
   * If invalid, what is the error?
   */
  invalidText: _propTypes.default.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: _propTypes.default.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: _propTypes.default.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes.default.array.isRequired,

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: _propTypes.default.node.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * Specify the locale of the control. Used for the default `compareItems`
   * used for sorting the list of items in the control.
   */
  locale: _propTypes.default.string,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: _propTypes.default.func,

  /**
   * `onMenuChange` is a utility for this controlled component to communicate to a
   * consuming component that the menu was opend(`true`)/closed(`false`).
   */
  onMenuChange: _propTypes.default.func,

  /**
   * Initialize the component with an open(`true`)/closed(`false`) menu.
   */
  open: _propTypes.default.bool,

  /**
   * For full control of the selected items
   */
  selectedItems: _propTypes.default.array,

  /**
   * Specify feedback (mode) of the selection.
   * `top`: selected item jumps to top
   * `fixed`: selected item stays at it's position
   * `top-after-reopen`: selected item jump to top after reopen dropdown
   */
  selectionFeedback: _propTypes.default.oneOf(['top', 'fixed', 'top-after-reopen']),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBox.PropTypes.ListBoxSize,

  /**
   * Provide text to be used in a `<label>` element that is tied to the
   * multiselect via ARIA attributes.
   */
  titleText: _propTypes.default.node,

  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: _propTypes.default.func,

  /**
   * Specify 'inline' to create an inline multi-select.
   */
  type: _propTypes.default.oneOf(['default', 'inline']),

  /**
   * Specify title to show title on hover
   */
  useTitleInItem: _propTypes.default.bool,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});
MultiSelect.defaultProps = {
  compareItems: _sorting.defaultCompareItems,
  disabled: false,
  locale: 'en',
  itemToString: _itemToString2.defaultItemToString,
  initialSelectedItems: [],
  sortItems: _sorting.defaultSortItems,
  type: 'default',
  light: false,
  title: false,
  open: false,
  selectionFeedback: 'top-after-reopen',
  direction: 'bottom',
  clearSelectionText: 'To clear selection, press Delete or Backspace,',
  clearSelectionDescription: 'Total items selected: ',
  selectedItems: null
};
var _default = MultiSelect;
exports.default = _default;