"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _downshift = _interopRequireDefault(require("downshift"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _filter = require("../ComboBox/tools/filter");

var _MultiSelectPropTypes = require("./MultiSelectPropTypes");

var _ListBox = _interopRequireWildcard(require("../ListBox"));

var _next = require("../ListBox/next");

var _keyboard = require("../../internal/keyboard");

var _Selection = _interopRequireDefault(require("../../internal/Selection"));

var _createPropAdapter = require("../../tools/createPropAdapter");

var _itemToString = require("./tools/itemToString");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _sorting = require("./tools/sorting");

var _FeatureFlags = require("../FeatureFlags");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _setupGetInstanceId.default)();

var FilterableMultiSelect = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(FilterableMultiSelect, _React$Component);

  var _super = _createSuper(FilterableMultiSelect);

  function FilterableMultiSelect(props) {
    var _this;

    (0, _classCallCheck2.default)(this, FilterableMultiSelect);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnChange", function (changes) {
      if (_this.props.onChange) {
        _this.props.onChange(changes);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnMenuChange", function (isOpen) {
      _this.setState(function (state) {
        return {
          isOpen: isOpen !== null && isOpen !== void 0 ? isOpen : !state.isOpen
        };
      });

      if (_this.props.onMenuChange) {
        _this.props.onMenuChange(isOpen);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnOuterClick", function () {
      _this.handleOnMenuChange(false);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnStateChange", function (changes, downshift) {
      if (changes.isOpen && !_this.state.isOpen) {
        _this.setState({
          topItems: downshift.selectedItem
        });
      }

      var type = changes.type;
      var stateChangeTypes = _downshift.default.stateChangeTypes;

      switch (type) {
        case stateChangeTypes.keyDownArrowDown:
        case stateChangeTypes.keyDownArrowUp:
        case stateChangeTypes.keyDownHome:
        case stateChangeTypes.keyDownEnd:
          _this.setState({
            highlightedIndex: changes.highlightedIndex !== undefined ? changes.highlightedIndex : null
          });

          if (stateChangeTypes.keyDownArrowDown === type && !_this.state.isOpen) {
            _this.handleOnMenuChange(true);
          }

          break;

        case stateChangeTypes.keyDownEscape:
          _this.handleOnMenuChange(false);

          break;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnInputKeyDown", function (event) {
      event.stopPropagation();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnInputValueChange", function (inputValue, _ref) {
      var type = _ref.type;

      if (type !== _downshift.default.stateChangeTypes.changeInput) {
        return;
      }

      _this.setState(function () {
        if (Array.isArray(inputValue)) {
          return {
            inputValue: ''
          };
        }

        return {
          inputValue: inputValue || ''
        };
      });

      if (inputValue && !_this.state.isOpen) {
        _this.handleOnMenuChange(true);
      } else if (!inputValue && _this.state.isOpen) {
        _this.handleOnMenuChange(false);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "clearInputValue", function () {
      _this.setState({
        inputValue: ''
      }, function () {
        if (_this.textInput.current) {
          _this.textInput.current.focus();
        }
      });
    });
    _this.filterableMultiSelectInstanceId = getInstanceId();
    _this.state = {
      isOpen: props.open,
      inputValue: '',
      topItems: [],
      inputFocused: false,
      highlightedIndex: null
    };
    _this.textInput = /*#__PURE__*/_react.default.createRef();
    return _this;
  }

  (0, _createClass2.default)(FilterableMultiSelect, [{
    key: "render",
    value: function render() {
      var _cx,
          _cx2,
          _cx3,
          _cx4,
          _this2 = this;

      var _this$state = this.state,
          highlightedIndex = _this$state.highlightedIndex,
          isOpen = _this$state.isOpen,
          inputValue = _this$state.inputValue;
      var _this$props = this.props,
          ariaLabel = _this$props.ariaLabel,
          containerClassName = _this$props.className,
          direction = _this$props.direction,
          disabled = _this$props.disabled,
          filterItems = _this$props.filterItems,
          items = _this$props.items,
          itemToElement = _this$props.itemToElement,
          itemToString = _this$props.itemToString,
          titleText = _this$props.titleText,
          hideLabel = _this$props.hideLabel,
          helperText = _this$props.helperText,
          type = _this$props.type,
          initialSelectedItems = _this$props.initialSelectedItems,
          id = _this$props.id,
          locale = _this$props.locale,
          size = _this$props.size,
          placeholder = _this$props.placeholder,
          sortItems = _this$props.sortItems,
          compareItems = _this$props.compareItems,
          light = _this$props.light,
          invalid = _this$props.invalid,
          invalidText = _this$props.invalidText,
          warn = _this$props.warn,
          warnText = _this$props.warnText,
          useTitleInItem = _this$props.useTitleInItem,
          translateWithId = _this$props.translateWithId,
          downshiftProps = _this$props.downshiftProps;
      var inline = type === 'inline';
      var showWarning = !invalid && warn; // needs to be capitalized for react to render it correctly

      var ItemToElement = itemToElement;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--multi-select__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--multi-select__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx));
      var helperId = !helperText ? undefined : "filterablemultiselect-helper-text-".concat(this.filterableMultiSelectInstanceId);
      var labelId = "".concat(id, "-label");
      var titleClasses = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label--disabled"), disabled), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
      var helperClasses = (0, _classnames.default)((_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--form__helper-text"), true), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--form__helper-text--disabled"), disabled), _cx3));
      var inputClasses = (0, _classnames.default)((_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input"), true), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input--empty"), !this.state.inputValue), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--text-input--light"), light), _cx4));
      var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
        id: helperId,
        className: helperClasses
      }, helperText) : null;
      var menuId = "".concat(id, "__menu");
      var inputId = "".concat(id, "-input");
      return /*#__PURE__*/_react.default.createElement(_Selection.default, {
        disabled: disabled,
        onChange: this.handleOnChange,
        initialSelectedItems: initialSelectedItems,
        render: function render(_ref2) {
          var selectedItems = _ref2.selectedItems,
              onItemChange = _ref2.onItemChange,
              _clearSelection = _ref2.clearSelection;
          return /*#__PURE__*/_react.default.createElement(_downshift.default, (0, _extends2.default)({}, (0, _createPropAdapter.mapDownshiftProps)(downshiftProps), {
            highlightedIndex: highlightedIndex,
            id: id,
            isOpen: isOpen,
            inputValue: inputValue,
            onInputValueChange: _this2.handleOnInputValueChange,
            onChange: function onChange(selectedItem) {
              if (selectedItem !== null) {
                onItemChange(selectedItem);
              }
            },
            itemToString: itemToString,
            onStateChange: _this2.handleOnStateChange,
            onOuterClick: _this2.handleOnOuterClick,
            selectedItem: selectedItems,
            labelId: labelId,
            menuId: menuId,
            inputId: inputId
          }), function (_ref3) {
            var _cx5;

            var getInputProps = _ref3.getInputProps,
                getItemProps = _ref3.getItemProps,
                getLabelProps = _ref3.getLabelProps,
                getMenuProps = _ref3.getMenuProps,
                getRootProps = _ref3.getRootProps,
                getToggleButtonProps = _ref3.getToggleButtonProps,
                isOpen = _ref3.isOpen,
                inputValue = _ref3.inputValue,
                selectedItem = _ref3.selectedItem;
            var className = (0, _classnames.default)("".concat(prefix, "--multi-select"), "".concat(prefix, "--combo-box"), "".concat(prefix, "--multi-select--filterable"), [enabled ? null : containerClassName], (_cx5 = {}, (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--invalid"), invalid), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--open"), isOpen), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--inline"), inline), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--selected"), selectedItem.length > 0), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--multi-select--filterable--input-focused"), _this2.state.inputFocused), _cx5));
            var rootProps = getRootProps({}, {
              suppressRefError: true
            });
            var labelProps = getLabelProps();
            var buttonProps = getToggleButtonProps({
              disabled: disabled,
              onClick: function onClick() {
                _this2.handleOnMenuChange(!_this2.state.isOpen);

                if (_this2.textInput.current) {
                  _this2.textInput.current.focus();
                }
              },
              // When we moved the "root node" of Downshift to the <input> for
              // ARIA 1.2 compliance, we unfortunately hit this branch for the
              // "mouseup" event that downshift listens to:
              // https://github.com/downshift-js/downshift/blob/v5.2.1/src/downshift.js#L1051-L1065
              //
              // As a result, it will reset the state of the component and so we
              // stop the event from propagating to prevent this. This allows the
              // toggleMenu behavior for the toggleButton to correctly open and
              // close the menu.
              onMouseUp: function onMouseUp(event) {
                event.stopPropagation();
              }
            });
            var inputProps = getInputProps({
              'aria-controls': isOpen ? menuId : null,
              'aria-describedby': helperText ? helperId : null,
              // Remove excess aria `aria-labelledby`. HTML <label for>
              // provides this aria information.
              'aria-labelledby': null,
              disabled: disabled,
              placeholder: placeholder,
              onClick: function onClick() {
                _this2.handleOnMenuChange(true);
              },
              onKeyDown: function onKeyDown(event) {
                if ((0, _keyboard.match)(event, _keyboard.keys.Space)) {
                  event.stopPropagation();
                }
              },
              onFocus: function onFocus() {
                _this2.setState({
                  inputFocused: true
                });
              },
              onBlur: function onBlur() {
                _this2.setState({
                  inputFocused: false
                });
              }
            });
            var menuProps = getMenuProps({
              'aria-label': ariaLabel
            }, {
              suppressRefError: true
            });
            return /*#__PURE__*/_react.default.createElement("div", {
              className: wrapperClasses
            }, titleText ? /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
              className: titleClasses
            }, labelProps), titleText) : null, /*#__PURE__*/_react.default.createElement(_ListBox.default, {
              className: className,
              disabled: disabled,
              light: light,
              invalid: invalid,
              invalidText: invalidText,
              warn: warn,
              warnText: warnText,
              isOpen: isOpen,
              size: size
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "".concat(prefix, "--list-box__field")
            }, selectedItem.length > 0 && /*#__PURE__*/_react.default.createElement(_next.ListBoxSelection, {
              clearSelection: function clearSelection() {
                _clearSelection();

                if (_this2.textInput.current) {
                  _this2.textInput.current.focus();
                }
              },
              selectionCount: selectedItem.length,
              translateWithId: translateWithId,
              disabled: disabled
            }), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
              className: inputClasses
            }, rootProps, inputProps, {
              ref: (0, _mergeRefs.default)(_this2.textInput, rootProps.ref)
            })), invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
              className: "".concat(prefix, "--list-box__invalid-icon")
            }), showWarning && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
              className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
            }), inputValue && /*#__PURE__*/_react.default.createElement(_next.ListBoxSelection, {
              clearSelection: _this2.clearInputValue,
              disabled: disabled,
              translateWithId: translateWithId,
              onMouseUp: function onMouseUp(event) {
                // If we do not stop this event from propagating,
                // it seems like Downshift takes our event and
                // prevents us from getting `onClick` /
                // `clearSelection` from the underlying <button> in
                // ListBoxSelection
                event.stopPropagation();
              }
            }), /*#__PURE__*/_react.default.createElement(_next.ListBoxTrigger, (0, _extends2.default)({}, buttonProps, {
              isOpen: isOpen,
              translateWithId: translateWithId
            }))), isOpen ? /*#__PURE__*/_react.default.createElement(_ListBox.default.Menu, menuProps, sortItems(filterItems(items, {
              itemToString: itemToString,
              inputValue: inputValue
            }), {
              selectedItems: {
                top: selectedItems,
                fixed: [],
                'top-after-reopen': _this2.state.topItems
              }[_this2.props.selectionFeedback],
              itemToString: itemToString,
              compareItems: compareItems,
              locale: locale
            }).map(function (item, index) {
              var itemProps = getItemProps({
                item: item,
                disabled: item.disabled
              });
              var itemText = itemToString(item);
              var isChecked = selectedItem.filter(function (selected) {
                return (0, _lodash.default)(selected, item);
              }).length > 0;
              return /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuItem, (0, _extends2.default)({
                key: itemProps.id,
                "aria-label": itemText,
                isActive: isChecked,
                isHighlighted: highlightedIndex === index,
                title: itemText
              }, itemProps), /*#__PURE__*/_react.default.createElement("div", {
                className: "".concat(prefix, "--checkbox-wrapper")
              }, /*#__PURE__*/_react.default.createElement("span", {
                title: useTitleInItem ? itemText : null,
                className: "".concat(prefix, "--checkbox-label"),
                "data-contained-checkbox-state": isChecked,
                id: "".concat(itemProps.id, "-item")
              }, itemToElement ? /*#__PURE__*/_react.default.createElement(ItemToElement, (0, _extends2.default)({
                key: itemProps.id
              }, item)) : itemText)));
            })) : null), !inline && !invalid && !warn ? helper : null);
          });
        }
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref4, state) {
      var open = _ref4.open;

      /**
       * programmatically control this `open` prop
       */
      var prevOpen = state.prevOpen;
      return prevOpen === open ? null : {
        isOpen: open,
        prevOpen: open
      };
    }
  }]);
  return FilterableMultiSelect;
}(_react.default.Component);

exports.default = FilterableMultiSelect;
(0, _defineProperty2.default)(FilterableMultiSelect, "propTypes", _objectSpread(_objectSpread({
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify the direction of the multiselect dropdown. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: _propTypes.default.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: _propTypes.default.shape(_downshift.default.propTypes),

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Allow users to pass in arbitrary items from their collection that are
   * pre-selected
   */
  initialSelectedItems: _propTypes.default.array,

  /**
   * Is the current selection invalid?
   */
  invalid: _propTypes.default.bool,

  /**
   * If invalid, what is the error?
   */
  invalidText: _propTypes.default.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: _propTypes.default.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: _propTypes.default.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes.default.array.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * Specify the locale of the control. Used for the default `compareItems`
   * used for sorting the list of items in the control.
   */
  locale: _propTypes.default.string,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: _propTypes.default.func,

  /**
   * `onMenuChange` is a utility for this controlled component to communicate to a
   * consuming component that the menu was opened(`true`)/closed(`false`).
   */
  onMenuChange: _propTypes.default.func,

  /**
   * Initialize the component with an open(`true`)/closed(`false`) menu.
   */
  open: _propTypes.default.bool,

  /**
   * Generic `placeholder` that will be used as the textual representation of
   * what this field is for
   */
  placeholder: _propTypes.default.string.isRequired,

  /**
   * Specify feedback (mode) of the selection.
   * `top`: selected item jumps to top
   * `fixed`: selected item stays at it's position
   * `top-after-reopen`: selected item jump to top after reopen dropdown
   */
  selectionFeedback: _propTypes.default.oneOf(['top', 'fixed', 'top-after-reopen']),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBox.PropTypes.ListBoxSize
}, _MultiSelectPropTypes.sortingPropTypes), {}, {
  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: _propTypes.default.func,

  /**
   * Specify title to show title on hover
   */
  useTitleInItem: _propTypes.default.bool,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
}));
(0, _defineProperty2.default)(FilterableMultiSelect, "contextType", _FeatureFlags.FeatureFlagContext);
(0, _defineProperty2.default)(FilterableMultiSelect, "defaultProps", {
  ariaLabel: 'Choose an item',
  compareItems: _sorting.defaultCompareItems,
  direction: 'bottom',
  disabled: false,
  filterItems: _filter.defaultFilterItems,
  initialSelectedItems: [],
  itemToString: _itemToString.defaultItemToString,
  locale: 'en',
  sortItems: _sorting.defaultSortItems,
  light: false,
  open: false,
  selectionFeedback: 'top-after-reopen'
});