"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _toggleClass = _interopRequireDefault(require("../../../tools/toggleClass"));

var _Button = _interopRequireDefault(require("../../Button"));

var _ButtonSet = _interopRequireDefault(require("../../ButtonSet"));

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

var _requiredIfGivenPropIsTruthy = _interopRequireDefault(require("../../../prop-types/requiredIfGivenPropIsTruthy"));

var _wrapFocus = _interopRequireWildcard(require("../../../internal/wrapFocus"));

var _setupGetInstanceId = _interopRequireDefault(require("../../../tools/setupGetInstanceId"));

var _usePrefix = require("../../../internal/usePrefix");

var _Modal$propTypes;

var _excluded = ["children", "className", "modalHeading", "modalLabel", "modalAriaLabel", "passiveModal", "hasForm", "secondaryButtonText", "primaryButtonText", "open", "onRequestClose", "onRequestSubmit", "onSecondarySubmit", "iconDescription", "primaryButtonDisabled", "danger", "alert", "secondaryButtons", "selectorPrimaryFocus", "selectorsFloatingMenus", "shouldSubmitOnEnter", "size", "hasScrollingContent", "closeButtonLabel", "preventCloseOnClickOutside"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var getInstanceId = (0, _setupGetInstanceId.default)();

var Modal = /*#__PURE__*/_react.default.forwardRef(function Modal(_ref, ref) {
  var _classNames, _classNames3;

  var children = _ref.children,
      className = _ref.className,
      modalHeading = _ref.modalHeading,
      modalLabel = _ref.modalLabel,
      modalAriaLabel = _ref.modalAriaLabel,
      passiveModal = _ref.passiveModal,
      hasForm = _ref.hasForm,
      secondaryButtonText = _ref.secondaryButtonText,
      primaryButtonText = _ref.primaryButtonText,
      open = _ref.open,
      onRequestClose = _ref.onRequestClose,
      onRequestSubmit = _ref.onRequestSubmit,
      onSecondarySubmit = _ref.onSecondarySubmit,
      iconDescription = _ref.iconDescription,
      primaryButtonDisabled = _ref.primaryButtonDisabled,
      danger = _ref.danger,
      alert = _ref.alert,
      secondaryButtons = _ref.secondaryButtons,
      selectorPrimaryFocus = _ref.selectorPrimaryFocus,
      selectorsFloatingMenus = _ref.selectorsFloatingMenus,
      shouldSubmitOnEnter = _ref.shouldSubmitOnEnter,
      size = _ref.size,
      hasScrollingContent = _ref.hasScrollingContent,
      closeButtonLabel = _ref.closeButtonLabel,
      preventCloseOnClickOutside = _ref.preventCloseOnClickOutside,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var button = (0, _react.useRef)();
  var secondaryButton = (0, _react.useRef)();
  var innerModal = (0, _react.useRef)();
  var startTrap = (0, _react.useRef)();
  var endTrap = (0, _react.useRef)();
  var modalInstanceId = "modal-".concat(getInstanceId());
  var modalLabelId = "".concat(prefix, "--modal-header__label--").concat(modalInstanceId);
  var modalHeadingId = "".concat(prefix, "--modal-header__heading--").concat(modalInstanceId);
  var modalBodyId = "".concat(prefix, "--modal-body--").concat(modalInstanceId);
  var modalCloseButtonClass = "".concat(prefix, "--modal-close");

  function isCloseButton(element) {
    return !onSecondarySubmit && element === secondaryButton.current || element.classList.contains(modalCloseButtonClass);
  }

  function handleKeyDown(evt) {
    if (open) {
      if (evt.which === 27) {
        onRequestClose(evt);
      }

      if (evt.which === 13 && shouldSubmitOnEnter && !isCloseButton(evt.target)) {
        onRequestSubmit(evt);
      }
    }
  }

  function handleMousedown(evt) {
    if (innerModal.current && !innerModal.current.contains(evt.target) && !(0, _wrapFocus.elementOrParentIsFloatingMenu)(evt.target, selectorsFloatingMenus) && !preventCloseOnClickOutside) {
      onRequestClose(evt);
    }
  }

  function handleBlur(_ref2) {
    var oldActiveNode = _ref2.target,
        currentActiveNode = _ref2.relatedTarget;

    if (open && currentActiveNode && oldActiveNode) {
      var bodyNode = innerModal.current;
      var startTrapNode = startTrap.current;
      var endTrapNode = endTrap.current;
      (0, _wrapFocus.default)({
        bodyNode: bodyNode,
        startTrapNode: startTrapNode,
        endTrapNode: endTrapNode,
        currentActiveNode: currentActiveNode,
        oldActiveNode: oldActiveNode,
        selectorsFloatingMenus: selectorsFloatingMenus
      });
    }
  }

  var onSecondaryButtonClick = onSecondarySubmit ? onSecondarySubmit : onRequestClose;
  var modalClasses = (0, _classnames.default)("".concat(prefix, "--modal"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--modal-tall"), !passiveModal), (0, _defineProperty2.default)(_classNames, 'is-visible', open), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--modal--danger"), danger), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
  var containerClasses = (0, _classnames.default)("".concat(prefix, "--modal-container"), (0, _defineProperty2.default)({}, "".concat(prefix, "--modal-container--").concat(size), size));
  var contentClasses = (0, _classnames.default)("".concat(prefix, "--modal-content"), (_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--modal-content--with-form"), hasForm), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), _classNames3));
  var footerClasses = (0, _classnames.default)("".concat(prefix, "--modal-footer"), (0, _defineProperty2.default)({}, "".concat(prefix, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2));

  var modalButton = /*#__PURE__*/_react.default.createElement("button", {
    className: modalCloseButtonClass,
    type: "button",
    onClick: onRequestClose,
    title: ariaLabel ? ariaLabel : iconDescription,
    "aria-label": closeButtonLabel ? closeButtonLabel : 'close',
    ref: button
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close20, {
    "aria-hidden": "true",
    tabIndex: "-1",
    className: "".concat(modalCloseButtonClass, "__icon")
  }));

  var ariaLabel = modalLabel || ['aria-label'] || modalAriaLabel || modalHeading;
  var getAriaLabelledBy = modalLabel ? modalLabelId : modalHeadingId;
  var hasScrollingContentProps = hasScrollingContent ? {
    tabIndex: 0,
    role: 'region',
    'aria-label': ariaLabel,
    'aria-labelledby': getAriaLabelledBy
  } : {};
  var alertDialogProps = {};

  if (alert && passiveModal) {
    alertDialogProps.role = 'alert';
  }

  if (alert && !passiveModal) {
    alertDialogProps.role = 'alertdialog';
    alertDialogProps['aria-describedby'] = modalBodyId;
  }

  (0, _react.useEffect)(function () {
    return function () {
      (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    };
  }, [prefix]);
  (0, _react.useEffect)(function () {
    (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), open);
  }, [open, prefix]);
  (0, _react.useEffect)(function () {
    var initialFocus = function initialFocus(focusContainerElement) {
      var containerElement = focusContainerElement || innerModal.current;
      var primaryFocusElement = containerElement ? containerElement.querySelector(selectorPrimaryFocus) : null;

      if (primaryFocusElement) {
        return primaryFocusElement;
      }

      return button && button.current;
    };

    var focusButton = function focusButton(focusContainerElement) {
      var target = initialFocus(focusContainerElement);

      if (target) {
        target.focus();
      }
    };

    if (open) {
      focusButton(innerModal.current);
    }
  }, [open, selectorPrimaryFocus]);

  var modalBody = /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: innerModal,
    role: "dialog"
  }, alertDialogProps, {
    className: containerClasses,
    "aria-label": ariaLabel,
    "aria-modal": "true",
    tabIndex: "-1"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--modal-header")
  }, passiveModal && modalButton, modalLabel && /*#__PURE__*/_react.default.createElement("h2", {
    id: modalLabelId,
    className: "".concat(prefix, "--modal-header__label")
  }, modalLabel), /*#__PURE__*/_react.default.createElement("h3", {
    id: modalHeadingId,
    className: "".concat(prefix, "--modal-header__heading")
  }, modalHeading), !passiveModal && modalButton), /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    id: modalBodyId,
    className: contentClasses
  }, hasScrollingContentProps, {
    "aria-labelledby": getAriaLabelledBy
  }), children), hasScrollingContent && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--modal-content--overflow-indicator")
  }), !passiveModal && /*#__PURE__*/_react.default.createElement(_ButtonSet.default, {
    className: footerClasses
  }, Array.isArray(secondaryButtons) && secondaryButtons.length <= 2 ? secondaryButtons.map(function (_ref3, i) {
    var buttonText = _ref3.buttonText,
        onButtonClick = _ref3.onClick;
    return /*#__PURE__*/_react.default.createElement(_Button.default, {
      key: "".concat(buttonText, "-").concat(i),
      kind: "secondary",
      onClick: onButtonClick
    }, buttonText);
  }) : secondaryButtonText && /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "secondary",
    onClick: onSecondaryButtonClick,
    ref: secondaryButton
  }, secondaryButtonText), /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: danger ? 'danger' : 'primary',
    disabled: primaryButtonDisabled,
    onClick: onRequestSubmit,
    ref: button
  }, primaryButtonText)));

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    onKeyDown: handleKeyDown,
    onMouseDown: handleMousedown,
    onBlur: handleBlur,
    className: modalClasses,
    role: "presentation",
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("span", {
    ref: startTrap,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"), modalBody, /*#__PURE__*/_react.default.createElement("span", {
    ref: endTrap,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"));
});

Modal.propTypes = (_Modal$propTypes = {
  /**
   * Specify whether the Modal is displaying an alert, error or warning
   * Should go hand in hand with the danger prop.
   */
  alert: _propTypes.default.bool
}, (0, _defineProperty2.default)(_Modal$propTypes, 'aria-label', (0, _requiredIfGivenPropIsTruthy.default)('hasScrollingContent', _propTypes.default.string)), (0, _defineProperty2.default)(_Modal$propTypes, "children", _propTypes.default.node), (0, _defineProperty2.default)(_Modal$propTypes, "className", _propTypes.default.string), (0, _defineProperty2.default)(_Modal$propTypes, "closeButtonLabel", _propTypes.default.string), (0, _defineProperty2.default)(_Modal$propTypes, "danger", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "focusTrap", (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `focusTrap` for Modal has been deprecated, as the feature of `focusTrap` runs by default.")), (0, _defineProperty2.default)(_Modal$propTypes, "hasForm", (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `hasForm` for Modal has been deprecated, as the feature of `hasForm` runs by default.")), (0, _defineProperty2.default)(_Modal$propTypes, "hasScrollingContent", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "iconDescription", (0, _deprecate.default)(_propTypes.default.string, 'The iconDescription prop is no longer needed and can be safely removed. This prop will be removed in the next major release of Carbon.')), (0, _defineProperty2.default)(_Modal$propTypes, "id", _propTypes.default.string), (0, _defineProperty2.default)(_Modal$propTypes, "modalAriaLabel", _propTypes.default.string), (0, _defineProperty2.default)(_Modal$propTypes, "modalHeading", _propTypes.default.node), (0, _defineProperty2.default)(_Modal$propTypes, "modalLabel", _propTypes.default.node), (0, _defineProperty2.default)(_Modal$propTypes, "onKeyDown", _propTypes.default.func), (0, _defineProperty2.default)(_Modal$propTypes, "onRequestClose", _propTypes.default.func), (0, _defineProperty2.default)(_Modal$propTypes, "onRequestSubmit", _propTypes.default.func), (0, _defineProperty2.default)(_Modal$propTypes, "onSecondarySubmit", _propTypes.default.func), (0, _defineProperty2.default)(_Modal$propTypes, "open", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "passiveModal", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "preventCloseOnClickOutside", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "primaryButtonDisabled", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "primaryButtonText", _propTypes.default.node), (0, _defineProperty2.default)(_Modal$propTypes, "secondaryButtonText", _propTypes.default.node), (0, _defineProperty2.default)(_Modal$propTypes, "secondaryButtons", function secondaryButtons(props, propName, componentName) {
  if (props.secondaryButtons) {
    if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
      return new Error("".concat(propName, " needs to be an array of two button config objects"));
    }

    var shape = {
      buttonText: _propTypes.default.node,
      onClick: _propTypes.default.func
    };
    props[propName].forEach(function (secondaryButton) {
      _propTypes.default.checkPropTypes(shape, secondaryButton, propName, componentName);
    });
  }

  return null;
}), (0, _defineProperty2.default)(_Modal$propTypes, "selectorPrimaryFocus", _propTypes.default.string), (0, _defineProperty2.default)(_Modal$propTypes, "selectorsFloatingMenus", _propTypes.default.arrayOf(_propTypes.default.string)), (0, _defineProperty2.default)(_Modal$propTypes, "shouldSubmitOnEnter", _propTypes.default.bool), (0, _defineProperty2.default)(_Modal$propTypes, "size", _propTypes.default.oneOf(['xs', 'sm', 'md', 'lg'])), _Modal$propTypes);
Modal.defaultProps = {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  primaryButtonDisabled: false,
  onKeyDown: function onKeyDown() {},
  passiveModal: false,
  modalHeading: '',
  modalLabel: '',
  preventCloseOnClickOutside: false,
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  hasScrollingContent: false
};
var _default = Modal;
exports.default = _default;