"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _iconsReact = require("@carbon/icons-react");

var _MenuOption = _interopRequireDefault(require("./MenuOption"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function MenuSelectableItem(_ref) {
  var label = _ref.label,
      initialChecked = _ref.initialChecked,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;

  var _useState = (0, _react.useState)(initialChecked),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      checked = _useState2[0],
      setChecked = _useState2[1];

  function handleClick() {
    setChecked(!checked);
    onChange(!checked);
  }

  return /*#__PURE__*/_react.default.createElement(_MenuOption.default, {
    role: "menuitemcheckbox",
    "aria-checked": checked,
    renderIcon: checked ? _iconsReact.Checkmark16 : null,
    label: label,
    indented: true,
    onClick: handleClick
  });
}

MenuSelectableItem.propTypes = {
  /**
   * Whether the option should be checked by default
   */
  initialChecked: _propTypes.default.bool,

  /**
   * Rendered label for the MenuOptionContent
   */
  label: _propTypes.default.node.isRequired,

  /**
   * Callback function when selection the has been changed
   */
  onChange: _propTypes.default.func
};
var _default = MenuSelectableItem;
exports.default = _default;