"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _MenuGroup = _interopRequireDefault(require("./MenuGroup"));

var _MenuRadioGroupOptions = _interopRequireDefault(require("./MenuRadioGroupOptions"));

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function MenuRadioGroup(_ref) {
  var items = _ref.items,
      initialSelectedItem = _ref.initialSelectedItem,
      label = _ref.label,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;
  return /*#__PURE__*/_react.default.createElement(_MenuGroup.default, {
    label: label
  }, /*#__PURE__*/_react.default.createElement(_MenuRadioGroupOptions.default, {
    items: items,
    initialSelectedItem: initialSelectedItem,
    onChange: onChange
  }));
}

MenuRadioGroup.propTypes = {
  /**
   * Whether the option should be checked by default
   */
  initialSelectedItem: _propTypes.default.string,

  /**
   * Array of the radio options
   */
  items: _propTypes.default.arrayOf(_propTypes.default.string).isRequired,

  /**
   * The radio group label
   */
  label: _propTypes.default.string.isRequired,

  /**
   * Callback function when selection the has been changed
   */
  onChange: _propTypes.default.func
};
var _default = MenuRadioGroup;
exports.default = _default;