"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["id", "active", "className", "withOverlay", "small", "description"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var getInstanceId = (0, _setupGetInstanceId.default)();

function Loading(_ref) {
  var _cx, _cx2;

  var id = _ref.id,
      active = _ref.active,
      customClassName = _ref.className,
      withOverlay = _ref.withOverlay,
      small = _ref.small,
      description = _ref.description,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var _useRef = (0, _react.useRef)(getInstanceId()),
      instanceId = _useRef.current;

  var loadingClassName = (0, _classnames.default)(customClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--loading"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--loading--small"), small), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--loading--stop"), !active), _cx));
  var overlayClassName = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--loading-overlay"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--loading-overlay--stop"), !active), _cx2));
  var loadingId = id || "loading-id-".concat(instanceId);

  var loading = /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    "aria-atomic": "true",
    "aria-labelledby": loadingId,
    "aria-live": active ? 'assertive' : 'off',
    className: loadingClassName
  }), /*#__PURE__*/_react.default.createElement("label", {
    id: loadingId,
    className: "".concat(prefix, "--visually-hidden")
  }, description), /*#__PURE__*/_react.default.createElement("svg", {
    className: "".concat(prefix, "--loading__svg"),
    viewBox: "0 0 100 100"
  }, /*#__PURE__*/_react.default.createElement("title", null, description), small ? /*#__PURE__*/_react.default.createElement("circle", {
    className: "".concat(prefix, "--loading__background"),
    cx: "50%",
    cy: "50%",
    r: "44"
  }) : null, /*#__PURE__*/_react.default.createElement("circle", {
    className: "".concat(prefix, "--loading__stroke"),
    cx: "50%",
    cy: "50%",
    r: "44"
  })));

  return withOverlay ? /*#__PURE__*/_react.default.createElement("div", {
    className: overlayClassName
  }, loading) : loading;
}

Loading.propTypes = {
  /**
   * Specify whether you want the loading indicator to be spinning or not
   */
  active: _propTypes.default.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify a description that would be used to best describe the loading state
   */
  description: _propTypes.default.string,

  /**
   * Provide an `id` to uniquely identify the label
   */
  id: _propTypes.default.string,

  /**
   * Specify whether you would like the small variant of <Loading>
   */
  small: _propTypes.default.bool,

  /**
   * Specify whether you want the loader to be applied with an overlay
   */
  withOverlay: _propTypes.default.bool
};
Loading.defaultProps = {
  active: true,
  withOverlay: true,
  small: false,
  description: 'Active loading indicator'
};
var _default = Loading;
exports.default = _default;