"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponents = require("carbon-components");

var _excluded = ["children", "isActive", "isHighlighted", "title"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

function useIsTruncated(ref) {
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isTruncated = _useState2[0],
      setIsTruncated = _useState2[1];

  (0, _react.useEffect)(function () {
    var _ref$current = ref.current,
        offsetWidth = _ref$current.offsetWidth,
        scrollWidth = _ref$current.scrollWidth;
    setIsTruncated(offsetWidth < scrollWidth);
  }, [ref, setIsTruncated]);
  return isTruncated;
}
/**
 * `ListBoxMenuItem` is a helper component for managing the container class
 * name, alongside any classes for any corresponding states, for a generic list
 * box menu item.
 */


var ListBoxMenuItem = /*#__PURE__*/_react.default.forwardRef(function ListBoxMenuItem(_ref, forwardedRef) {
  var _cx;

  var children = _ref.children,
      isActive = _ref.isActive,
      isHighlighted = _ref.isHighlighted,
      title = _ref.title,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var ref = (0, _react.useRef)(null);
  var isTruncated = useIsTruncated((forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref);
  var className = (0, _classnames.default)("".concat(prefix, "--list-box__menu-item"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__menu-item--active"), isActive), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__menu-item--highlighted"), isHighlighted), _cx));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: className,
    title: isTruncated ? title : undefined
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--list-box__menu-item__option"),
    ref: (forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref
  }, children));
});

ListBoxMenuItem.displayName = 'ListBoxMenuItem';
ListBoxMenuItem.propTypes = {
  /**
   * Specify any children nodes that should be rendered inside of the ListBox
   * Menu Item
   */
  children: _propTypes.default.node,

  /**
   * Specify whether the current menu item is "active".
   */
  isActive: _propTypes.default.bool.isRequired,

  /**
   * Specify whether the current menu item is "highlighted".
   */
  isHighlighted: _propTypes.default.bool.isRequired,

  /**
   * Provide an optional tooltip for the ListBoxMenuItem
   */
  title: _propTypes.default.string
};
ListBoxMenuItem.defaultProps = {
  isActive: false,
  isHighlighted: false
};
var _default = ListBoxMenuItem;
exports.default = _default;