"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.translationIds = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _defaultTranslations;

var prefix = _carbonComponents.settings.prefix;
var translationIds = {
  'close.menu': 'close.menu',
  'open.menu': 'open.menu'
};
exports.translationIds = translationIds;
var defaultTranslations = (_defaultTranslations = {}, (0, _defineProperty2.default)(_defaultTranslations, translationIds['close.menu'], 'Close menu'), (0, _defineProperty2.default)(_defaultTranslations, translationIds['open.menu'], 'Open menu'), _defaultTranslations);
/**
 * `ListBoxMenuIcon` is used to orient the icon up or down depending on the
 * state of the menu for a given `ListBox`
 */

var ListBoxMenuIcon = function ListBoxMenuIcon(_ref) {
  var isOpen = _ref.isOpen,
      t = _ref.translateWithId;
  var className = (0, _classnames.default)("".concat(prefix, "--list-box__menu-icon"), (0, _defineProperty2.default)({}, "".concat(prefix, "--list-box__menu-icon--open"), isOpen));
  var description = isOpen ? t('close.menu') : t('open.menu');
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, {
    name: "chevron--down",
    "aria-label": description
  }, /*#__PURE__*/_react.default.createElement("title", null, description)));
};

ListBoxMenuIcon.propTypes = {
  /**
   * Specify whether the menu is currently open, which will influence the
   * direction of the menu icon
   */
  isOpen: _propTypes.default.bool.isRequired,

  /**
   * i18n hook used to provide the appropriate description for the given menu
   * icon. This function takes in an id defined in `translationIds` and should
   * return a string message for that given message id.
   */
  translateWithId: _propTypes.default.func.isRequired
};
ListBoxMenuIcon.defaultProps = {
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
};
var _default = ListBoxMenuIcon;
exports.default = _default;