"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponents = require("carbon-components");

var _ListBoxPropTypes = require("./ListBoxPropTypes");

var _excluded = ["children", "className", "disabled", "type", "size", "invalid", "invalidText", "warn", "warnText", "light", "isOpen"];
var prefix = _carbonComponents.settings.prefix;

var handleOnKeyDown = function handleOnKeyDown(event) {
  if (event.keyCode === 27) {
    event.stopPropagation();
  }
};

var handleClick = function handleClick(event) {
  event.preventDefault();
  event.stopPropagation();
};
/**
 * `ListBox` is a generic container component that handles creating the
 * container class name in response to certain props.
 */


var ListBox = /*#__PURE__*/_react.default.forwardRef(function ListBox(_ref, ref) {
  var _cx;

  var children = _ref.children,
      containerClassName = _ref.className,
      disabled = _ref.disabled,
      type = _ref.type,
      size = _ref.size,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      light = _ref.light,
      isOpen = _ref.isOpen,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var showWarning = !invalid && warn;
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, containerClassName, !!containerClassName), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--").concat(size), size), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--inline"), type === 'inline'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--disabled"), disabled), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--light"), light), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--expanded"), isOpen), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--warning"), showWarning), _cx));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: className,
    ref: ref,
    onKeyDown: handleOnKeyDown,
    onClick: handleClick,
    "data-invalid": invalid || undefined
  }), children), invalid ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, invalidText) : null, showWarning ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, warnText) : null);
});

ListBox.displayName = 'ListBox';
ListBox.propTypes = {
  /**
   * Provide the contents of your ListBox
   */
  children: _propTypes.default.node,

  /**
   * Specify a class name to be applied on the containing list box node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the ListBox is currently disabled
   */
  disabled: _propTypes.default.bool.isRequired,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Specify the text to be displayed when the control is invalid
   */
  invalidText: _propTypes.default.node,

  /**
   * Specify if the control should render open
   */
  isOpen: _propTypes.default.bool,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBoxPropTypes.ListBoxSize,

  /**
   * Specify the "type" of the ListBox. Currently supports either `default` or
   * `inline` as an option.
   */
  type: _ListBoxPropTypes.ListBoxType.isRequired,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
ListBox.defaultProps = {
  disabled: false,
  type: 'default'
};
var _default = ListBox;
exports.default = _default;