"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "href", "disabled", "inline", "visited", "renderIcon", "size"];

var Link = function Link(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      href = _ref.href,
      disabled = _ref.disabled,
      inline = _ref.inline,
      visited = _ref.visited,
      Icon = _ref.renderIcon,
      size = _ref.size,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classNames = (0, _classnames2.default)("".concat(prefix, "--link"), className, (_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--link--disabled"), disabled), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--link--inline"), inline), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--link--visited"), visited), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--link--").concat(size), size), _classnames));
  var Tag = disabled ? 'p' : 'a';
  var rel = other.target === '_blank' ? 'noopener' : null;
  return /*#__PURE__*/_react.default.createElement(Tag, (0, _extends2.default)({
    href: disabled ? null : href,
    className: classNames,
    rel: rel
  }, other), children, !inline && Icon && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--link__icon")
  }, /*#__PURE__*/_react.default.createElement(Icon, null)));
};

Link.propTypes = {
  /**
   * Provide the content for the Link
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied to the containing `<a>` node
   */
  className: _propTypes.default.string,

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide the `href` attribute for the `<a>` node
   */
  href: _propTypes.default.string,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: _propTypes.default.bool,

  /**
   * Optional prop to render an icon next to the link.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the size of the Link. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg']),

  /**
   * Specify whether you want the link to receive visited styles after the link has been clicked
   */
  visited: _propTypes.default.bool
};
var _default = Link;
exports.default = _default;