"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layer = Layer;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _LayerContext = require("./LayerContext");

var _excluded = ["as", "className", "children"];
var levels = ['one', 'two', 'three'];
var MAX_LEVEL = levels.length - 1;

function Layer(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      customClassName = _ref.className,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var level = _react.default.useContext(_LayerContext.LayerContext);

  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)("".concat(prefix, "--layer-").concat(levels[level]), customClassName);
  return (
    /*#__PURE__*/
    // The level should be between 0 and MAX_LEVEL
    _react.default.createElement(_LayerContext.LayerContext.Provider, {
      value: Math.max(0, Math.min(level + 1, MAX_LEVEL))
    }, /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
      className: className
    }), children))
  );
}

Layer.propTypes = {
  /**
   * Specify a custom component or element to be rendered as the top-level
   * element in the component
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements to be rendered inside of `Theme`
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be used on the outermost element rendered by
   * the component
   */
  className: _propTypes.default.string
};