"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.default = void 0;

var _iconsReact = require("@carbon/icons-react");

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_IconButton',
  component: _.IconButton,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    layout: 'centered'
  },
  argTypes: {
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    }
  }
};
exports.default = _default;

var PlaygroundStory = function PlaygroundStory(props) {
  var align = props.align,
      defaultOpen = props.defaultOpen,
      disabled = props.disabled,
      kind = props.kind,
      label = props.label;
  return /*#__PURE__*/_react.default.createElement(_.IconButton, {
    align: align,
    defaultOpen: defaultOpen,
    disabled: disabled,
    kind: kind,
    label: label
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Edit16, null));
};

var Playground = PlaygroundStory.bind({});
exports.Playground = Playground;
Playground.argTypes = {
  align: {
    defaultValue: 'bottom',
    options: ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'right'],
    control: {
      type: 'select'
    }
  },
  defaultOpen: {
    defaultValue: true
  },
  disabled: {
    defaultValue: false,
    control: {
      type: 'boolean'
    }
  },
  label: {
    control: {
      type: 'text'
    },
    defaultValue: 'Custom label'
  },
  kind: {
    control: {
      type: 'select'
    },
    defaultValue: 'primary',
    options: ['primary', 'secondary', 'ghost', 'tertiary']
  }
};