"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = Section;
exports.Heading = Heading;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _excluded = ["as", "children"];

var HeadingContext = /*#__PURE__*/_react.default.createContext(1);

function Section(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'section' : _ref$as,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var level = _react.default.useContext(HeadingContext);

  return /*#__PURE__*/_react.default.createElement(HeadingContext.Provider, {
    value: Math.min(level + 1, 6)
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, rest, children));
}

Section.propTypes = {
  /**
   * Provide an alternative tag or component to use instead of the default
   * <section> element
   */
  as: _propTypes.default.elementType,

  /**
   * Specify the content that will be placed in the component
   */
  children: _propTypes.default.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: _propTypes.default.string
};

function Heading(props) {
  var level = _react.default.useContext(HeadingContext);

  return /*#__PURE__*/_react.default.createElement("h".concat(level), props);
}

Heading.propTypes = {
  /**
   * Specify the content that will be placed in the component
   */
  children: _propTypes.default.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: _propTypes.default.string
};