"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mixedGridModes = exports.fullWidth = exports.narrowColumns = exports.narrow = exports.condensedColumns = exports.condensed = exports.offset = exports.responsiveGrid = exports.autoColumns = exports.experimentalCSSGrid = exports.default = void 0;

require("./Grid-story.scss");

var _react = _interopRequireDefault(require("react"));

var _ = require("./");

var _Grid = _interopRequireDefault(require("./Grid.mdx"));

var _FeatureFlags = require("../FeatureFlags");

var _Heading = require("../Heading");

var _default = {
  title: 'Components/Grid',
  component: _.Grid,
  subcomponents: {
    Row: _.Row,
    Column: _.Column
  },
  decorators: [function (storyFn) {
    return /*#__PURE__*/_react.default.createElement("div", {
      id: "templates"
    }, storyFn());
  }],
  parameters: {
    docs: {
      page: _Grid.default
    }
  }
};
exports.default = _default;

function DemoContent(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "outside"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "inside"
  }, children));
}

var experimentalCSSGrid = function experimentalCSSGrid() {
  return /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-css-grid': true
    }
  }, /*#__PURE__*/_react.default.createElement(_Heading.Heading, null, "Wide"), /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 2,
    md: 4,
    lg: 8
  }, "Subgrid"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 2,
    md: 4,
    lg: 8
  }, "Subgrid"))), /*#__PURE__*/_react.default.createElement(_Heading.Heading, null, "Narrow"), /*#__PURE__*/_react.default.createElement(_.Grid, {
    narrow: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column")), /*#__PURE__*/_react.default.createElement(_Heading.Heading, null, "Condensed"), /*#__PURE__*/_react.default.createElement(_.Grid, {
    condensed: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column")));
};

exports.experimentalCSSGrid = experimentalCSSGrid;

var autoColumns = function autoColumns() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Span 25%"))));
};

exports.autoColumns = autoColumns;

var responsiveGrid = function responsiveGrid() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 2,
    md: 4,
    lg: 6
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, /*#__PURE__*/_react.default.createElement("p", null, "Small: Span 2 of 4"), /*#__PURE__*/_react.default.createElement("p", null, "Medium: Span 4 of 8"), /*#__PURE__*/_react.default.createElement("p", null, "Large: Span 6 of 12"))), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 2,
    md: 2,
    lg: 3
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, /*#__PURE__*/_react.default.createElement("p", null, "Small: Span 2 of 4"), /*#__PURE__*/_react.default.createElement("p", null, "Medium: Span 2 of 8"), /*#__PURE__*/_react.default.createElement("p", null, "Large: Span 3 of 12"))), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: 0,
    md: 2,
    lg: 3
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, /*#__PURE__*/_react.default.createElement("p", null, "Small: Span 0 of 4"), /*#__PURE__*/_react.default.createElement("p", null, "Medium: Span 2 of 8"), /*#__PURE__*/_react.default.createElement("p", null, "Large: Span 3 of 12")))));
};

exports.responsiveGrid = responsiveGrid;

var offset = function offset() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: {
      span: 1,
      offset: 3
    }
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Small: offset 3")), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: {
      span: 2,
      offset: 2
    }
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Small: offset 2")), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: {
      span: 3,
      offset: 1
    }
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Small: offset 1")), /*#__PURE__*/_react.default.createElement(_.Column, {
    sm: {
      span: 4,
      offset: 0
    }
  }, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Small: offset 0"))));
};

exports.offset = offset;

var condensed = function condensed() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, {
    condensed: true
  }, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.condensed = condensed;

var condensedColumns = function condensedColumns() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, {
    condensed: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.condensedColumns = condensedColumns;

var narrow = function narrow() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, {
    narrow: true
  }, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.narrow = narrow;

var narrowColumns = function narrowColumns() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, {
    narrow: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.narrowColumns = narrowColumns;

var fullWidth = function fullWidth() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.fullWidth = fullWidth;

var mixedGridModes = function mixedGridModes() {
  return /*#__PURE__*/_react.default.createElement(_.Grid, null, /*#__PURE__*/_react.default.createElement(_.Row, null, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Wide")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, {
    narrow: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Narrow")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/_react.default.createElement(_.Row, {
    condensed: true
  }, /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "Condensed")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4")), /*#__PURE__*/_react.default.createElement(_.Column, null, /*#__PURE__*/_react.default.createElement(DemoContent, null, "1/4"))));
};

exports.mixedGridModes = mixedGridModes;