"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _excluded = ["className", "children", "id"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var FormLabel = function FormLabel(_ref) {
  var _classnames;

  var className = _ref.className,
      children = _ref.children,
      id = _ref.id,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classNames = (0, _classnames2.default)((_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--label"), !FeatureFlags.enabled('enable-v11-release')), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--label--no-margin"), FeatureFlags.enabled('enable-v11-release')), _classnames), className);
  return /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
    htmlFor: id,
    className: classNames
  }, other), children);
};

FormLabel.propTypes = {
  /**
   * Specify the content of the form label
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied to the containing <label> node
   */
  className: _propTypes.default.string,

  /**
   * Provide a unique id for the given <FormLabel>
   */
  id: _propTypes.default.string
};
var _default = FormLabel;
exports.default = _default;