"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports._Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _FormGroup = _interopRequireDefault(require("./FormGroup"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _RadioButtonGroup = _interopRequireDefault(require("../RadioButtonGroup"));

var _RadioButton = _interopRequireDefault(require("../RadioButton"));

var _Button = _interopRequireDefault(require("../Button"));

var _FormGroup2 = _interopRequireDefault(require("./FormGroup.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    legendId: (0, _addonKnobs.text)('Legend ID (legendId)', 'formgroup-legend-id'),
    legendText: (0, _addonKnobs.text)('Legend text (legendText)', 'FormGroup Legend'),
    hasMargin: (0, _addonKnobs.boolean)('Fieldset has bottom margin (hasMargin)', true)
  };
};

var _default = {
  title: 'Components/FormGroup',
  parameters: {
    component: _FormGroup.default,
    docs: {
      page: _FormGroup2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_FormGroup.default, {
    legendId: "formgroup-legend-id",
    legendText: "FormGroup Legend",
    style: {
      maxWidth: '400px'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "one",
    labelText: "First Name"
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "two",
    labelText: "Last Name"
  })), /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  })));
};

exports._Default = _Default;
_Default.story = {
  name: 'Form Group'
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_FormGroup.default, (0, _extends2.default)({
    className: "test"
  }, props(), {
    style: {
      maxWidth: '400px'
    }
  }), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "one",
    labelText: "First Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "two",
    labelText: "Last Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }))), /*#__PURE__*/_react.default.createElement(_Button.default, null, "Submit"));
};

exports.Playground = Playground;