"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _Checkbox = _interopRequireDefault(require("../../Checkbox"));

var _ = _interopRequireDefault(require("../"));

var _FormGroup = _interopRequireDefault(require("../../FormGroup"));

var _FileUploader = _interopRequireDefault(require("../../FileUploader"));

var _NumberInput = _interopRequireDefault(require("../../NumberInput"));

var _RadioButton = _interopRequireDefault(require("../../RadioButton"));

var _RadioButtonGroup = _interopRequireDefault(require("../../RadioButtonGroup"));

var _Button = _interopRequireDefault(require("../../Button"));

var _Search = _interopRequireDefault(require("../../Search"));

var _Select = _interopRequireDefault(require("../../Select"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _TextArea = _interopRequireDefault(require("../../TextArea"));

var _TextInput = _interopRequireDefault(require("../../TextInput"));

var _Toggle = _interopRequireDefault(require("../../Toggle"));

var _Stack = require("../../Stack");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var checkboxEvents = {
  className: 'some-class',
  labelText: 'Checkbox label'
};

var fieldsetCheckboxProps = function fieldsetCheckboxProps() {
  return {
    className: 'some-class',
    legendText: 'Checkbox heading'
  };
};

var numberInputProps = {
  className: 'some-class',
  id: 'number-input-1',
  label: 'Number Input',
  min: 0,
  max: 100,
  value: 50,
  step: 10
};
var toggleProps = {
  className: 'some-class',
  hideLabel: true
};
var fieldsetToggleProps = {
  className: 'some-class',
  legendText: 'Toggle heading'
};
var fileUploaderEvents = {
  buttonLabel: 'Add files',
  className: 'some-class'
};
var fieldsetFileUploaderProps = {
  className: 'some-class',
  legendText: 'File Uploader'
};
var radioProps = {
  className: 'some-class'
};
var fieldsetRadioProps = {
  className: 'some-class',
  legendText: 'Radio Button heading'
};
var searchProps = {
  className: 'some-class',
  size: 'md'
};
var fieldsetSearchProps = {
  className: 'some-class',
  legendText: 'Search'
};
var selectProps = {
  className: 'some-class'
};
var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  placeholder: 'Placeholder text'
};
var PasswordProps = {
  className: 'some-class',
  id: 'test3',
  labelText: 'Password'
};
var InvalidPasswordProps = {
  className: 'some-class',
  id: 'test4',
  labelText: 'Password',
  invalid: true,
  invalidText: 'Your password must be at least 6 characters as well as contain at least one uppercase, one lowercase, and one number.'
};
var textareaProps = {
  labelText: 'Text Area label',
  className: 'some-class',
  placeholder: 'Placeholder text',
  id: 'test5',
  cols: 50,
  rows: 4
};
var buttonEvents = {
  className: 'some-class'
};
var _default = {
  title: 'Components/Form',
  component: _.default
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_.default, null, /*#__PURE__*/_react.default.createElement(_Stack.Stack, {
    gap: 6
  }, /*#__PURE__*/_react.default.createElement(_FormGroup.default, fieldsetCheckboxProps(), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({
    defaultChecked: true
  }, checkboxEvents, {
    id: "checkbox-0"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({}, checkboxEvents, {
    id: "checkbox-1"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({
    disabled: true
  }, checkboxEvents, {
    id: "checkbox-2"
  }))), /*#__PURE__*/_react.default.createElement(_NumberInput.default, numberInputProps), /*#__PURE__*/_react.default.createElement(_FormGroup.default, fieldsetToggleProps, /*#__PURE__*/_react.default.createElement(_Stack.Stack, {
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_Toggle.default, (0, _extends2.default)({}, toggleProps, {
    id: "toggle-1"
  })), /*#__PURE__*/_react.default.createElement(_Toggle.default, (0, _extends2.default)({
    disabled: true
  }, toggleProps, {
    id: "toggle-2"
  })))), /*#__PURE__*/_react.default.createElement(_FormGroup.default, fieldsetFileUploaderProps, /*#__PURE__*/_react.default.createElement(_FileUploader.default, (0, _extends2.default)({}, fileUploaderEvents, {
    id: "file-1",
    labelDescription: "Choose Files..."
  }))), /*#__PURE__*/_react.default.createElement(_FormGroup.default, fieldsetRadioProps, /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    name: "radio-button-group",
    defaultSelected: "default-selected"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, (0, _extends2.default)({
    value: "standard",
    id: "radio-1",
    labelText: "Standard Radio Button"
  }, radioProps)), /*#__PURE__*/_react.default.createElement(_RadioButton.default, (0, _extends2.default)({
    value: "default-selected",
    labelText: "Default Selected Radio Button",
    id: "radio-2"
  }, radioProps)), /*#__PURE__*/_react.default.createElement(_RadioButton.default, (0, _extends2.default)({
    value: "blue",
    labelText: "Standard Radio Button",
    id: "radio-3"
  }, radioProps)), /*#__PURE__*/_react.default.createElement(_RadioButton.default, (0, _extends2.default)({
    value: "disabled",
    labelText: "Disabled Radio Button",
    id: "radio-4",
    disabled: true
  }, radioProps)))), /*#__PURE__*/_react.default.createElement(_FormGroup.default, fieldsetSearchProps, /*#__PURE__*/_react.default.createElement(_Search.default, (0, _extends2.default)({}, searchProps, {
    id: "search-1",
    labelText: "Search",
    placeholder: "Search"
  }))), /*#__PURE__*/_react.default.createElement(_Select.default, (0, _extends2.default)({}, selectProps, {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  })), /*#__PURE__*/_react.default.createElement(_TextInput.default, TextInputProps), /*#__PURE__*/_react.default.createElement(_TextInput.default, (0, _extends2.default)({
    type: "password",
    required: true,
    pattern: "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}"
  }, PasswordProps)), /*#__PURE__*/_react.default.createElement(_TextInput.default, (0, _extends2.default)({
    type: "password",
    required: true,
    pattern: "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}"
  }, InvalidPasswordProps)), /*#__PURE__*/_react.default.createElement(_TextArea.default, textareaProps), /*#__PURE__*/_react.default.createElement(_Button.default, (0, _extends2.default)({
    type: "submit",
    className: "some-class"
  }, buttonEvents), "Submit")));
};

exports.Default = Default;