"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _FluidForm = _interopRequireDefault(require("../FluidForm"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var additionalProps = {
  className: 'some-class',
  onSubmit: function onSubmit(e) {
    e.preventDefault();
    (0, _addonActions.action)('FormSubmitted')(e);
  }
};
var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  placeholder: 'Placeholder text'
};
var InvalidPasswordProps = {
  className: 'some-class',
  id: 'test4',
  labelText: 'Password',
  invalid: true,
  invalidText: 'Your password must be at least 6 characters as well as contain at least one uppercase, one lowercase, and one number.'
};
var _default = {
  title: 'Experimental/FluidForm',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _FluidForm.default
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_FluidForm.default, additionalProps, /*#__PURE__*/_react.default.createElement(_TextInput.default, TextInputProps), /*#__PURE__*/_react.default.createElement(_TextInput.default, (0, _extends2.default)({
    type: "password",
    required: true,
    pattern: "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}"
  }, InvalidPasswordProps)));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Forms are widely used to collect user input.\n\n        Form can have any number of react components enclosed within FormGroup component. FormGroup component\n        is a wrapper for legend and fieldset component.\n\n      "
  }
};