"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Loading = _interopRequireDefault(require("../Loading"));

var _excluded = ["iconDescription", "status", "invalid"];
var prefix = _carbonComponents.settings.prefix;

function Filename(_ref) {
  var iconDescription = _ref.iconDescription,
      status = _ref.status,
      invalid = _ref.invalid,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  switch (status) {
    case 'uploading':
      return /*#__PURE__*/_react.default.createElement(_Loading.default, {
        description: iconDescription,
        small: true,
        withOverlay: false
      });

    case 'edit':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
        className: "".concat(prefix, "--file-invalid")
      }), /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-close"),
        type: "button"
      }, rest), /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));

    case 'complete':
      return /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, (0, _extends2.default)({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-complete")
      }, rest), iconDescription && /*#__PURE__*/_react.default.createElement("title", null, iconDescription));

    default:
      return null;
  }
}

Filename.propTypes = {
  /**
   * Provide a description of the SVG icon to denote file upload status
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify if the file is invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Status of the file upload
   */
  status: _propTypes.default.oneOf(['edit', 'complete', 'uploading']),

  /**
   * Provide a custom tabIndex value for the <Filename>
   */
  tabIndex: _propTypes.default.string
};
Filename.defaultProps = {
  iconDescription: 'Uploading file',
  status: 'uploading',
  tabIndex: '0'
};
var _default = Filename;
exports.default = _default;