"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dialog = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

require("wicg-inert");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _FocusScope = require("../FocusScope");

var _useMergedRefs = require("../../internal/useMergedRefs");

var _useSavedCallback = require("../../internal/useSavedCallback");

var _keyboard = require("../../internal/keyboard");

var _excluded = ["aria-labelledby", "children", "onDismiss"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * @see https://www.tpgi.com/the-current-state-of-modal-dialog-accessibility/
 */
var Dialog = /*#__PURE__*/_react.default.forwardRef(function Dialog(props, forwardRef) {
  var labelledBy = props['aria-labelledby'],
      children = props.children,
      onDismiss = props.onDismiss,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var dialogRef = (0, _react.useRef)(null);
  var ref = (0, _useMergedRefs.useMergedRefs)([dialogRef, forwardRef]);
  var savedOnDismiss = (0, _useSavedCallback.useSavedCallback)(onDismiss);

  function onKeyDown(event) {
    if ((0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      event.stopPropagation();
      savedOnDismiss();
    }
  }

  (0, _react.useEffect)(function () {
    var changes = hide(document.body, dialogRef.current);
    return function () {
      show(changes);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_FocusScope.FocusScope, (0, _extends2.default)({}, rest, {
    "aria-labelledby": labelledBy,
    "aria-modal": "true",
    initialFocusRef: dialogRef,
    onKeyDown: onKeyDown,
    ref: ref,
    role: "dialog",
    tabIndex: "-1"
  }), children);
});

exports.Dialog = Dialog;
Dialog.propTypes = {
  /**
   * Provide the associated element that labels the Dialog
   */
  'aria-labelledby': _propTypes.default.string.isRequired,

  /**
   * Provide children to be rendered inside of the Dialog
   */
  children: _propTypes.default.node,

  /**
   * Provide a handler that is called when the Dialog is requesting to be closed
   */
  onDismiss: _propTypes.default.func.isRequired
};

if (process.env.NODE_ENV !== "production") {
  Dialog.displayName = 'Dialog';
}

function hide(root, dialog) {
  var changes = [];
  var queue = Array.from(root.childNodes);

  while (queue.length !== 0) {
    var node = queue.shift();

    if (node.nodeType !== Node.ELEMENT_NODE) {
      continue;
    } // If a node is the dialog, do nothing


    if (node === dialog) {
      continue;
    } // If a tree contains our dialog, traverse its children


    if (node.contains(dialog)) {
      queue.push.apply(queue, (0, _toConsumableArray2.default)(Array.from(node.childNodes)));
      continue;
    } // If a node is a bumper, do nothing


    if (node.hasAttribute('data-carbon-focus-scope') && (dialog.previousSibling === node || dialog.nextSibling === node)) {
      continue;
    }

    if (node.getAttribute('aria-hidden') === 'true') {
      continue;
    }

    if (node.hasAttribute('inert')) {
      continue;
    }

    if (node.getAttribute('aria-hidden') === 'false') {
      node.setAttribute('aria-hidden', 'true');
      node.setAttribute('inert', '');
      changes.push({
        node: node,
        attributes: {
          'aria-hidden': 'false'
        }
      });
      continue;
    } // Otherwise, set it to inert and set aria-hidden to true


    node.setAttribute('aria-hidden', 'true');
    node.setAttribute('inert', '');
    changes.push({
      node: node
    });
  }

  return changes;
}

function show(changes) {
  changes.forEach(function (_ref) {
    var node = _ref.node,
        attributes = _ref.attributes;
    node.removeAttribute('inert'); // This mutation needs to be asynchronous to allow the polyfill time to
    // observe the change and allow mutations to occur
    // https://github.com/WICG/inert#performance-and-gotchas

    setTimeout(function () {
      if (attributes && attributes['aria-hidden']) {
        node.setAttribute('aria-hidden', attributes['aria-hidden']);
      } else {
        node.removeAttribute('aria-hidden');
      }
    }, 0);
  });
}