"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof3 = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _flatpickr2 = _interopRequireDefault(require("flatpickr"));

var _index = _interopRequireDefault(require("flatpickr/dist/l10n/index"));

var _DatePickerInput = _interopRequireDefault(require("../DatePickerInput"));

var _appendToPlugin = _interopRequireDefault(require("./plugins/appendToPlugin"));

var _fixEventsPlugin = _interopRequireDefault(require("./plugins/fixEventsPlugin"));

var _rangePlugin = _interopRequireDefault(require("./plugins/rangePlugin"));

var _keyboard = require("../../internal/keyboard");

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["allowInput", "appendTo", "datePickerType", "dateFormat", "locale", "minDate", "maxDate", "value", "onClose", "disable", "enable"],
    _excluded2 = ["dateFormat", "minDate", "maxDate", "value", "disable", "enable"],
    _excluded3 = ["dateFormat", "minDate", "maxDate", "value", "disable", "enable"],
    _excluded4 = ["allowInput", "appendTo", "children", "className", "short", "light", "datePickerType", "minDate", "maxDate", "dateFormat", "onChange", "locale", "value"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

// Weekdays shorthand for english locale
_index.default.en.weekdays.shorthand.forEach(function (day, index) {
  var currentDay = _index.default.en.weekdays.shorthand;

  if (currentDay[index] === 'Thu' || currentDay[index] === 'Th') {
    currentDay[index] = 'Th';
  } else {
    currentDay[index] = currentDay[index].charAt(0);
  }
});

var forEach = Array.prototype.forEach;
/**
 * @param {number} monthNumber The month number.
 * @param {boolean} shorthand `true` to use shorthand month.
 * @param {Locale} locale The Flatpickr locale data.
 * @returns {string} The month string.
 */

var monthToStr = function monthToStr(monthNumber, shorthand, locale) {
  return locale.months[shorthand ? 'shorthand' : 'longhand'][monthNumber];
};
/**
 * @param {object} config Plugin configuration.
 * @param {boolean} [config.shorthand] `true` to use shorthand month.
 * @param {string} config.selectorFlatpickrMonthYearContainer The CSS selector for the container of month/year selection UI.
 * @param {string} config.selectorFlatpickrYearContainer The CSS selector for the container of year selection UI.
 * @param {string} config.selectorFlatpickrCurrentMonth The CSS selector for the text-based month selection UI.
 * @param {string} config.classFlatpickrCurrentMonth The CSS class for the text-based month selection UI.
 * @returns {Plugin} A Flatpickr plugin to use text instead of `<select>` for month picker.
 */


var carbonFlatpickrMonthSelectPlugin = function carbonFlatpickrMonthSelectPlugin(config) {
  return function (fp) {
    var setupElements = function setupElements() {
      var _fp$monthElements;

      if (!fp.monthElements) {
        return;
      }

      fp.monthElements.forEach(function (elem) {
        if (!elem.parentNode) {
          return;
        }

        elem.parentNode.removeChild(elem);
      });

      (_fp$monthElements = fp.monthElements).splice.apply(_fp$monthElements, [0, fp.monthElements.length].concat((0, _toConsumableArray2.default)(fp.monthElements.map(function () {
        // eslint-disable-next-line no-underscore-dangle
        var monthElement = fp._createElement('span', config.classFlatpickrCurrentMonth);

        monthElement.textContent = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
        fp.yearElements[0].closest(config.selectorFlatpickrMonthYearContainer).insertBefore(monthElement, fp.yearElements[0].closest(config.selectorFlatpickrYearContainer));
        return monthElement;
      }))));
    };

    var updateCurrentMonth = function updateCurrentMonth() {
      var monthStr = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
      fp.yearElements.forEach(function (elem) {
        var currentMonthContainer = elem.closest(config.selectorFlatpickrMonthYearContainer);
        Array.prototype.forEach.call(currentMonthContainer.querySelectorAll('.cur-month'), function (monthElement) {
          monthElement.textContent = monthStr;
        });
      });
    };

    var register = function register() {
      fp.loadedPlugins.push('carbonFlatpickrMonthSelectPlugin');
    };

    return {
      onMonthChange: updateCurrentMonth,
      onValueUpdate: updateCurrentMonth,
      onOpen: updateCurrentMonth,
      onReady: [setupElements, updateCurrentMonth, register]
    };
  };
};

var DatePicker = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(DatePicker, _Component);

  var _super = _createSuper(DatePicker);

  function DatePicker() {
    var _this;

    (0, _classCallCheck2.default)(this, DatePicker);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChange", function () {
      var _this$cal;

      if (_this.inputField.value === '' && (_this$cal = _this.cal) !== null && _this$cal !== void 0 && _this$cal.selectedDates.length) {
        _this.cal.clear();

        _this.cal.input.focus();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addRoleAttributeToDialog", function () {
      if (_this.inputField) {
        _this.cal.calendarContainer.setAttribute('role', 'region'); // IBM EAAC requires an aria-label on a role='region'


        _this.cal.calendarContainer.setAttribute('aria-label', 'calendar-container');
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addKeyboardEvents", function (cal) {
      var initArrowDownListener = function initArrowDownListener(element) {
        if (element) {
          element.addEventListener('keydown', function (e) {
            if ((0, _keyboard.match)(e, _keyboard.keys.ArrowDown)) {
              var calendarContainer = cal.calendarContainer,
                  fpSelectedDateElem = cal.selectedDateElem,
                  fptodayDateElem = cal.todayDateElem;
              var selectedDateElem = calendarContainer.querySelector('.selected') && fpSelectedDateElem;
              var todayDateElem = calendarContainer.querySelector('.today') && fptodayDateElem;
              (selectedDateElem || todayDateElem || calendarContainer.querySelector('.flatpickr-day[tabindex]') || calendarContainer).focus();
            }
          });
          element.addEventListener('change', _this.onChange);
        }
      };

      initArrowDownListener(_this.inputField);
      initArrowDownListener(_this.toInputField);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "openCalendar", function () {
      if (_this.cal) {
        _this.cal.open();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateClassNames", function (calendar) {
      var calendarContainer = calendar.calendarContainer;
      var daysContainer = calendar.days;

      if (calendarContainer && daysContainer) {
        // calendarContainer and daysContainer are undefined if flatpickr detects a mobile device
        calendarContainer.classList.add("".concat(_this.context, "--date-picker__calendar"));
        calendarContainer.querySelector('.flatpickr-month').classList.add("".concat(_this.context, "--date-picker__month"));
        calendarContainer.querySelector('.flatpickr-weekdays').classList.add("".concat(_this.context, "--date-picker__weekdays"));
        calendarContainer.querySelector('.flatpickr-days').classList.add("".concat(_this.context, "--date-picker__days"));
        forEach.call(calendarContainer.querySelectorAll('.flatpickr-weekday'), function (item) {
          var currentItem = item;
          currentItem.innerHTML = currentItem.innerHTML.replace(/\s+/g, '');
          currentItem.classList.add("".concat(_this.context, "--date-picker__weekday"));
        });
        forEach.call(daysContainer.querySelectorAll('.flatpickr-day'), function (item) {
          item.classList.add("".concat(_this.context, "--date-picker__day"));

          if (item.classList.contains('today') && calendar.selectedDates.length > 0) {
            item.classList.add('no-border');
          } else if (item.classList.contains('today') && calendar.selectedDates.length === 0) {
            item.classList.remove('no-border');
          }
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "assignInputFieldRef", function (node) {
      _this.inputField = !node ? null : // Child is a regular DOM node, seen in tests
      node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(_this.context, "--date-picker__input")) : // Child is a React component
      node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "assignToInputFieldRef", function (node) {
      _this.toInputField = !node ? null : // Child is a regular DOM node, seen in tests
      node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(_this.context, "--date-picker__input")) : // Child is a React component
      node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isLabelTextEmpty", function (children) {
      return children.every(function (child) {
        return !child.props.labelText;
      });
    });
    return _this;
  }

  (0, _createClass2.default)(DatePicker, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var _this$props = this.props,
          allowInput = _this$props.allowInput,
          appendTo = _this$props.appendTo,
          datePickerType = _this$props.datePickerType,
          dateFormat = _this$props.dateFormat,
          locale = _this$props.locale,
          minDate = _this$props.minDate,
          maxDate = _this$props.maxDate,
          value = _this$props.value,
          onClose = _this$props.onClose,
          disable = _this$props.disable,
          enable = _this$props.enable,
          rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);

      if (datePickerType === 'single' || datePickerType === 'range') {
        var onHook = function onHook(electedDates, dateStr, instance) {
          _this2.updateClassNames(instance);
        }; // Logic to determine if `enable` or `disable` will be passed down. If neither
        // is provided, we return the default empty disabled array, allowing all dates.


        var enableOrDisable = enable ? 'enable' : 'disable';
        var enableOrDisableArr;

        if (!enable && !disable) {
          enableOrDisableArr = [];
        } else if (enable) {
          enableOrDisableArr = enable;
        } else {
          enableOrDisableArr = disable;
        }

        var localeData;

        if ((0, _typeof2.default)(locale) === 'object') {
          var location = locale.locale ? locale.locale : 'en';
          localeData = _objectSpread(_objectSpread({}, _index.default[location]), locale);
        } else {
          localeData = _index.default[locale];
        } // inputField ref might not be set in enzyme tests


        if (this.inputField) {
          var _rest$inline, _flatpickr;

          this.cal = new _flatpickr2.default(this.inputField, (_flatpickr = {
            inline: (_rest$inline = rest.inline) !== null && _rest$inline !== void 0 ? _rest$inline : false,
            disableMobile: true,
            defaultDate: value,
            mode: datePickerType,
            allowInput: allowInput !== null && allowInput !== void 0 ? allowInput : true,
            dateFormat: dateFormat,
            locale: localeData
          }, (0, _defineProperty2.default)(_flatpickr, enableOrDisable, enableOrDisableArr), (0, _defineProperty2.default)(_flatpickr, "minDate", minDate), (0, _defineProperty2.default)(_flatpickr, "maxDate", maxDate), (0, _defineProperty2.default)(_flatpickr, "plugins", [datePickerType === 'range' ? new _rangePlugin.default({
            input: this.toInputField
          }) : function () {}, appendTo ? (0, _appendToPlugin.default)({
            appendTo: appendTo
          }) : function () {}, carbonFlatpickrMonthSelectPlugin({
            selectorFlatpickrMonthYearContainer: '.flatpickr-current-month',
            selectorFlatpickrYearContainer: '.numInputWrapper',
            selectorFlatpickrCurrentMonth: '.cur-month',
            classFlatpickrCurrentMonth: 'cur-month'
          }), (0, _fixEventsPlugin.default)({
            inputFrom: this.inputField,
            inputTo: this.toInputField
          })]), (0, _defineProperty2.default)(_flatpickr, "clickOpens", true), (0, _defineProperty2.default)(_flatpickr, "nextArrow", this.rightArrowHTML()), (0, _defineProperty2.default)(_flatpickr, "prevArrow", this.leftArrowHTML()), (0, _defineProperty2.default)(_flatpickr, "onChange", function onChange() {
            var onChange = _this2.props.onChange;

            if (onChange) {
              onChange.apply(void 0, arguments);
            }
          }), (0, _defineProperty2.default)(_flatpickr, "onClose", onClose), (0, _defineProperty2.default)(_flatpickr, "onReady", onHook), (0, _defineProperty2.default)(_flatpickr, "onMonthChange", onHook), (0, _defineProperty2.default)(_flatpickr, "onYearChange", onHook), (0, _defineProperty2.default)(_flatpickr, "onOpen", function onOpen() {
            var onOpen = _this2.props.onOpen;
            onHook.apply(void 0, arguments);

            if (onOpen) {
              onOpen.apply(void 0, arguments);
            }
          }), (0, _defineProperty2.default)(_flatpickr, "onValueUpdate", onHook), _flatpickr));
          this.addKeyboardEvents(this.cal);
          this.addRoleAttributeToDialog();
        }
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var prevDateFormat = _ref.dateFormat,
          prevMinDate = _ref.minDate,
          prevMaxDate = _ref.maxDate,
          prevValue = _ref.value,
          prevDisable = _ref.disable,
          prevEnable = _ref.enable,
          prevRest = (0, _objectWithoutProperties2.default)(_ref, _excluded2);
      var _this$props2 = this.props,
          dateFormat = _this$props2.dateFormat,
          minDate = _this$props2.minDate,
          maxDate = _this$props2.maxDate,
          value = _this$props2.value,
          disable = _this$props2.disable,
          enable = _this$props2.enable,
          rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded3);

      if (this.cal) {
        if (prevDateFormat !== dateFormat) {
          this.cal.set({
            dateFormat: dateFormat
          });
        }

        if (prevMinDate !== minDate) {
          this.cal.set('minDate', minDate);
        }

        if (prevMaxDate !== maxDate) {
          this.cal.set('maxDate', maxDate);
        }

        if (disable !== prevDisable) {
          this.cal.set('disable', disable);
        }

        if (enable !== prevEnable) {
          this.cal.set('enable', enable);
        }

        if (rest.inline && rest.inline !== (prevRest === null || prevRest === void 0 ? void 0 : prevRest.inline)) {
          this.cal.set('inline', rest.inline);
        }
      } // Coordinate when the given `value` prop changes. When this happens, we
      // should update the calendar to the new value.


      if (prevValue !== value) {
        if (this.cal) {
          this.cal.setDate(this.props.value);
          this.updateClassNames(this.cal);
        } else if (this.inputField) {
          this.inputField.value = this.props.value;
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.cal) {
        this.cal.destroy();
      }

      if (this.inputField) {
        this.inputField.removeEventListener('change', this.onChange);
      }

      if (this.toInputField) {
        this.toInputField.removeEventListener('change', this.onChange);
      }
    }
  }, {
    key: "rightArrowHTML",
    value: function rightArrowHTML() {
      return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"11,8 6,13 5.3,12.3 9.6,8 5.3,3.7 6,3 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
    }
  }, {
    key: "leftArrowHTML",
    value: function leftArrowHTML() {
      return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"5,8 10,3 10.7,3.7 6.4,8 10.7,12.3 10,13 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlagContext.Consumer, null, function (scope) {
        var _classNames;

        var _this3$props = _this3.props,
            allowInput = _this3$props.allowInput,
            appendTo = _this3$props.appendTo,
            children = _this3$props.children,
            className = _this3$props.className,
            short = _this3$props.short,
            light = _this3$props.light,
            datePickerType = _this3$props.datePickerType,
            minDate = _this3$props.minDate,
            maxDate = _this3$props.maxDate,
            dateFormat = _this3$props.dateFormat,
            onChange = _this3$props.onChange,
            locale = _this3$props.locale,
            value = _this3$props.value,
            other = (0, _objectWithoutProperties2.default)(_this3$props, _excluded4);
        var enabled;

        if (scope.enabled) {
          enabled = scope.enabled('enable-v11-release');
        }

        var datePickerClasses = (0, _classnames.default)("".concat(_this3.context, "--date-picker"), [enabled ? null : className], (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--short"), short), (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--simple"), datePickerType === 'simple'), (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--single"), datePickerType === 'single'), (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--range"), datePickerType === 'range'), (0, _defineProperty2.default)(_classNames, "".concat(_this3.context, "--date-picker--nolabel"), datePickerType === 'range' && _this3.isLabelTextEmpty(children)), _classNames));
        var wrapperClasses = (0, _classnames.default)("".concat(_this3.context, "--form-item"), [enabled ? className : null]);

        var childArray = _react.default.Children.toArray(children);

        var childrenWithProps = childArray.map(function (child, index) {
          if (index === 0 && child.type === /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, child.props).type) {
            return /*#__PURE__*/_react.default.cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignInputFieldRef,
              openCalendar: _this3.openCalendar
            });
          }

          if (index === 1 && child.type === /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, child.props).type) {
            return /*#__PURE__*/_react.default.cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignToInputFieldRef,
              openCalendar: _this3.openCalendar
            });
          }

          if (index === 0) {
            return /*#__PURE__*/_react.default.cloneElement(child, {
              ref: _this3.assignInputFieldRef
            });
          }

          if (index === 1) {
            return /*#__PURE__*/_react.default.cloneElement(child, {
              ref: _this3.assignToInputFieldRef
            });
          }
        });
        return /*#__PURE__*/_react.default.createElement("div", {
          className: wrapperClasses
        }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
          className: datePickerClasses
        }, other), childrenWithProps));
      });
    }
  }]);
  return DatePicker;
}(_react.Component);

exports.default = DatePicker;
(0, _defineProperty2.default)(DatePicker, "propTypes", {
  /**
   * flatpickr prop passthrough. Allows the user to enter a date directly
   * into the input field
   */
  allowInput: _propTypes.default.bool,

  /**
   * The DOM element the Flatpicker should be inserted into. `<body>` by default.
   */
  appendTo: _propTypes.default.object,

  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * The date format.
   */
  dateFormat: _propTypes.default.string,

  /**
   * The type of the date picker:
   *
   * * `simple` - Without calendar dropdown.
   * * `single` - With calendar dropdown and single date.
   * * `range` - With calendar dropdown and a date range.
   */
  datePickerType: _propTypes.default.oneOf(['simple', 'single', 'range']),

  /**
   * The flatpickr `disable` option that allows a user to disable certain dates.
   */
  disable: _propTypes.default.array,

  /**
   * The flatpickr `enable` option that allows a user to enable certain dates.
   */
  enable: _propTypes.default.array,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   *  The language locale used to format the days of the week, months, and numbers. The full list of supported locales can be found here https://github.com/flatpickr/flatpickr/tree/master/src/l10n
   */
  locale: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.oneOf(['ar', // Arabic
  'at', // Austria
  'az', // Azerbaijan
  'be', // Belarusian
  'bg', // Bulgarian
  'bn', // Bangla
  'bs', // Bosnia
  'cat', // Catalan
  'cs', // Czech
  'cy', // Welsh
  'da', // Danish
  'de', // German
  'en', // English
  'eo', // Esperanto
  'es', // Spanish
  'et', // Estonian
  'fa', // Persian
  'fi', // Finnish
  'fo', // Faroese
  'fr', // French
  'ga', // Gaelic
  'gr', // Greek
  'he', // Hebrew
  'hi', // Hindi
  'hr', // Croatian
  'hu', // Hungarian
  'id', // Indonesian
  'is', // Icelandic
  'it', // Italian
  'ja', // Japanese
  'ka', // Georgian
  'km', // Khmer
  'ko', // Korean
  'kz', // Kazakh
  'lt', // Lithuanian
  'lv', // Latvian
  'mk', // Macedonian
  'mn', // Mongolian
  'ms', // Malaysian
  'my', // Burmese
  'nl', // Dutch
  'no', // Norwegian
  'pa', // Punjabi
  'pl', // Polish
  'pt', // Portuguese
  'ro', // Romanian
  'ru', // Russian
  'si', // Sinhala
  'sk', // Slovak
  'sl', // Slovenian
  'sq', // Albanian
  'sr', // Serbian
  'sv', // Swedish
  'th', // Thai
  'tr', // Turkish
  'uk', // Ukrainian
  'uz', // Uzbek
  'uz_latn', // Uzbek Latin
  'vn', // Vietnamese
  'zh_tw', // Mandarin Traditional
  'zh' // Mandarin
  ])]),

  /**
   * The maximum date that a user can pick to.
   */
  maxDate: _propTypes.default.string,

  /**
   * The minimum date that a user can start picking from.
   */
  minDate: _propTypes.default.string,

  /**
   * The `change` event handler.
   */
  onChange: _propTypes.default.func,

  /**
   * The `close` event handler.
   */
  onClose: _propTypes.default.func,

  /**
   * The `open` event handler.
   */
  onOpen: _propTypes.default.func,

  /**
   * `true` to use the short version.
   */
  short: _propTypes.default.bool,

  /**
   * The value of the date value provided to flatpickr, could
   * be a date, a date number, a date string, an array of dates.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.object])), _propTypes.default.object, _propTypes.default.number])
});
(0, _defineProperty2.default)(DatePicker, "defaultProps", {
  short: false,
  light: false,
  dateFormat: 'm/d/Y',
  locale: 'en'
});
(0, _defineProperty2.default)(DatePicker, "contextType", _usePrefix.PrefixContext);