"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _DataTableSkeleton = _interopRequireDefault(require("../DataTableSkeleton"));

var _shared = require("../DataTable/stories/shared");

var _excluded = ["showHeaders"];

var props = function props() {
  return {
    showHeaders: (0, _addonKnobs.boolean)('Show table headers', true),
    zebra: (0, _addonKnobs.boolean)('Use zebra stripe (zebra)', false),
    compact: (0, _addonKnobs.boolean)('Compact variant (compact)', false),
    showHeader: (0, _addonKnobs.boolean)('Show the Table Header (showHeader)', true),
    showToolbar: (0, _addonKnobs.boolean)('Show the Table Toolbar (showToolbar)', true)
  };
};

var _default = {
  title: 'Components/DataTable',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _DataTableSkeleton.default
  }
};
exports.default = _default;

var Skeleton = function Skeleton() {
  var _props = props(),
      showHeaders = _props.showHeaders,
      rest = (0, _objectWithoutProperties2.default)(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/_react.default.createElement(_DataTableSkeleton.default, (0, _extends2.default)({}, rest, {
    headers: showHeaders ? _shared.headers : null
  })), /*#__PURE__*/_react.default.createElement("br", null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'default';
Skeleton.parameters = {
  info: {
    text: "\n        Skeleton states are used as a progressive loading state while the user waits for content to load.\n\n        This example shows a skeleton state for a data table.\n      "
  }
};