"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Example = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

require("./story.scss");

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _iconsReact = require("@carbon/icons-react");

var _DataTable = _interopRequireWildcard(require("../../../DataTable"));

var _shared = require("../shared");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var sizes = {
  Compact: 'compact',
  Short: 'short',
  Medium: 'md',
  Default: null,
  Tall: 'tall'
};
var tableProps = {
  sizeProp: function sizeProp() {
    return {
      size: (0, _addonKnobs.select)('Row size (size)', sizes, null)
    };
  }
};
var _default = {
  title: 'Components/DataTable/Development',
  decorators: [_addonKnobs.withKnobs]
};
exports.default = _default;

var Example = function Example(props) {
  var insertInRandomPosition = function insertInRandomPosition(array, element) {
    var index = Math.floor(Math.random() * (array.length + 1));
    return [].concat((0, _toConsumableArray2.default)(array.slice(0, index)), [element], (0, _toConsumableArray2.default)(array.slice(index)));
  };

  var DynamicRows = /*#__PURE__*/function (_React$Component) {
    (0, _inherits2.default)(DynamicRows, _React$Component);

    var _super = _createSuper(DynamicRows);

    function DynamicRows() {
      var _this;

      (0, _classCallCheck2.default)(this, DynamicRows);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));
      (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
        rows: _shared.rows,
        headers: _shared.headers,
        id: 0
      });
      (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnHeaderAdd", function () {
        var length = _this.state.headers.length;
        var header = {
          key: "header_".concat(length),
          header: "Header ".concat(length)
        };

        _this.setState(function (state) {
          var rows = state.rows.map(function (row) {
            return _objectSpread(_objectSpread({}, row), {}, (0, _defineProperty2.default)({}, header.key, header.header));
          });
          return {
            rows: rows,
            headers: state.headers.concat(header)
          };
        });
      });
      (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnRowAdd", function () {
        _this.setState(function (state) {
          var _id = state.id,
              rows = state.rows;
          var id = _id + 1;
          var row = {
            id: '' + id,
            name: "New Row ".concat(id),
            protocol: 'HTTP',
            port: id * 100,
            rule: id % 2 === 0 ? 'Round robin' : 'DNS delegation',
            attached_groups: "Row ".concat(id, "'s VM Groups"),
            status: 'Starting'
          };
          state.headers.filter(function (header) {
            return row[header.key] === undefined;
          }).forEach(function (header) {
            row[header.key] = header.header;
          });
          return {
            id: id,
            rows: insertInRandomPosition(rows, row)
          };
        });
      });
      return _this;
    }

    (0, _createClass2.default)(DynamicRows, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var sizeProp = tableProps.sizeProp();
        return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
          rows: this.state.rows,
          headers: this.state.headers
        }, this.props, {
          render: function render(_ref) {
            var rows = _ref.rows,
                headers = _ref.headers,
                getHeaderProps = _ref.getHeaderProps,
                getSelectionProps = _ref.getSelectionProps,
                getToolbarProps = _ref.getToolbarProps,
                getBatchActionProps = _ref.getBatchActionProps,
                getRowProps = _ref.getRowProps,
                onInputChange = _ref.onInputChange,
                selectedRows = _ref.selectedRows,
                getTableProps = _ref.getTableProps,
                getTableContainerProps = _ref.getTableContainerProps;
            return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
              title: "DataTable",
              description: "Use the toolbar menu to add rows and headers"
            }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbar, getToolbarProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchActions, getBatchActionProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Delete16,
              iconDescription: "Delete the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Delete"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Save16,
              iconDescription: "Save the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Save"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Download16,
              iconDescription: "Download the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Download")), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarContent, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarSearch, {
              onChange: onInputChange
            }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarMenu, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
              onClick: _this2.handleOnRowAdd
            }, "Add row"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
              onClick: _this2.handleOnHeaderAdd
            }, "Add header")))), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), sizeProp), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
              return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
                key: i
              }, getHeaderProps({
                header: header
              })), header.header);
            }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
              return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
                key: row.id
              }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
                row: row
              }), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
                row: row
              })), row.cells.map(function (cell) {
                return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
                  key: cell.id
                }, cell.value);
              })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
                colSpan: headers.length + 3,
                className: "demo-expanded-td"
              }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
            }))));
          }
        }));
      }
    }]);
    return DynamicRows;
  }(_react.default.Component);

  return /*#__PURE__*/_react.default.createElement(DynamicRows, props);
};

exports.Example = Example;