"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _iconsReact = require("@carbon/icons-react");

var _excluded = ["className", "renderIcon", "iconDescription", "children"];
var prefix = _carbonComponents.settings.prefix;

var TableToolbarMenu = function TableToolbarMenu(_ref) {
  var className = _ref.className,
      renderIcon = _ref.renderIcon,
      iconDescription = _ref.iconDescription,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var toolbarActionClasses = (0, _classnames.default)(className, "".concat(prefix, "--toolbar-action ").concat(prefix, "--overflow-menu"));
  return /*#__PURE__*/_react.default.createElement(_OverflowMenu.default, (0, _extends2.default)({
    ariaLabel: iconDescription,
    renderIcon: renderIcon,
    className: toolbarActionClasses,
    title: iconDescription,
    iconDescription: iconDescription,
    flipped: true
  }, rest), children);
};

TableToolbarMenu.defaultProps = {
  renderIcon: _iconsReact.Settings16,
  iconDescription: 'Settings'
};
TableToolbarMenu.propTypes = {
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class name for the toolbar menu
   */
  className: _propTypes.default.string,

  /**
   * The description of the menu icon.
   */
  iconDescription: _propTypes.default.string.isRequired,

  /**
   * Optional prop to allow overriding the default menu icon
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])
};
var _default = TableToolbarMenu;
exports.default = _default;