"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _excluded = ["children", "size"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var prefix = _carbonComponents.settings.prefix;

var TableToolbar = function TableToolbar(_ref) {
  var _cx;

  var children = _ref.children,
      size = _ref.size,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--table-toolbar"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--table-toolbar--").concat(size), size), _cx));
  return /*#__PURE__*/_react.default.createElement("section", (0, _extends2.default)({}, rest, {
    className: className
  }), children);
};

TableToolbar.propTypes = _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Pass in the children that will be rendered inside the TableToolbar
   */
  children: _propTypes.default.node,

  /**
   * `normal` Change the row height of table
   * V11: remove small, normal
   */
  size: _propTypes.default.oneOf(['small', 'sm', 'normal', 'lg'])
});
TableToolbar.defaultProps = {
  'aria-label': 'data table toolbar'
};
var _default = TableToolbar;
exports.default = _default;