"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _InlineCheckbox = _interopRequireDefault(require("../InlineCheckbox"));

var _RadioButton = _interopRequireDefault(require("../RadioButton"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;

var TableSelectRow = function TableSelectRow(_ref) {
  var _classNames;

  var ariaLabel = _ref.ariaLabel,
      checked = _ref.checked,
      id = _ref.id,
      name = _ref.name,
      onSelect = _ref.onSelect,
      onChange = _ref.onChange,
      disabled = _ref.disabled,
      radio = _ref.radio,
      className = _ref.className;
  var selectionInputProps = {
    id: id,
    name: name,
    onClick: onSelect,
    onChange: onChange,
    checked: checked,
    disabled: disabled
  };
  var InlineInputComponent = radio ? _RadioButton.default : _InlineCheckbox.default;
  var tableSelectRowClasses = (0, _classnames.default)("".concat(prefix, "--table-column-checkbox"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, className, className), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--table-column-radio"), radio), _classNames));
  return /*#__PURE__*/_react.default.createElement("td", {
    className: tableSelectRowClasses
  }, /*#__PURE__*/_react.default.createElement(InlineInputComponent, (0, _extends2.default)({}, selectionInputProps, radio && {
    labelText: ariaLabel,
    hideLabel: true
  }, !radio && {
    ariaLabel: ariaLabel
  })));
};

TableSelectRow.propTypes = {
  /**
   * Specify the aria label for the underlying input control
   */
  ariaLabel: _propTypes.default.string.isRequired,

  /**
   * Specify whether all items are selected, or not
   */
  checked: _propTypes.default.bool.isRequired,

  /**
   * The CSS class names of the cell that wraps the underlying input control
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide an `id` for the underlying input control
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Provide a `name` for the underlying input control
   */
  name: _propTypes.default.string.isRequired,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a handler to listen to when a user initiates a selection request
   */
  onSelect: _propTypes.default.func.isRequired,

  /**
   * Specify whether the control should be a radio button or inline checkbox
   */
  radio: _propTypes.default.bool
};
var _default = TableSelectRow;
exports.default = _default;