"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _carbonComponents = require("carbon-components");

var _TableCell = _interopRequireDefault(require("./TableCell"));

var _excluded = ["className", "children", "colSpan"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

var TableExpandedRow = function TableExpandedRow(_ref) {
  var customClassName = _ref.className,
      children = _ref.children,
      colSpan = _ref.colSpan,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var rowRef = (0, _react.useRef)(null);
  var className = (0, _classnames.default)("".concat(prefix, "--expandable-row"), customClassName);

  var toggleParentHoverClass = function toggleParentHoverClass(eventType) {
    if (rowRef && rowRef.current && rowRef.current.previousElementSibling) {
      var parentNode = rowRef.current.previousElementSibling;

      if (eventType === 'enter') {
        parentNode.classList.add("".concat(prefix, "--expandable-row--hover"));
      } else {
        parentNode.classList.remove("".concat(prefix, "--expandable-row--hover"));
      }
    }
  };

  return /*#__PURE__*/_react.default.createElement("tr", (0, _extends2.default)({
    ref: rowRef,
    onMouseEnter: function onMouseEnter() {
      return toggleParentHoverClass('enter');
    },
    onMouseLeave: function onMouseLeave() {
      return toggleParentHoverClass('leave');
    }
  }, rest, {
    className: className,
    "data-child-row": true
  }), /*#__PURE__*/_react.default.createElement(_TableCell.default, {
    colSpan: colSpan
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--child-row-inner-container")
  }, children)));
};

TableExpandedRow.propTypes = {
  /**
   * Pass in the contents for your TableExpandedRow
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * The width of the expanded row's internal cell
   */
  colSpan: _propTypes.default.number.isRequired
};
var _default = TableExpandedRow;
exports.default = _default;