"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _requiredIfGivenPropIsTruthy = _interopRequireDefault(require("../../prop-types/requiredIfGivenPropIsTruthy"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _excluded = ["ariaLabel", "className", "enableExpando", "enableToggle", "isExpanded", "onExpand", "expandIconDescription", "children"];
var prefix = _carbonComponents.settings.prefix;

var TableExpandHeader = function TableExpandHeader(_ref) {
  var ariaLabel = _ref.ariaLabel,
      headerClassName = _ref.className,
      enableExpando = _ref.enableExpando,
      enableToggle = _ref.enableToggle,
      isExpanded = _ref.isExpanded,
      onExpand = _ref.onExpand,
      expandIconDescription = _ref.expandIconDescription,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var className = (0, _classnames.default)("".concat(prefix, "--table-expand"), headerClassName);
  var previousValue = isExpanded ? 'collapsed' : undefined;
  return /*#__PURE__*/_react.default.createElement("th", (0, _extends2.default)({
    scope: "col",
    className: className,
    "data-previous-value": previousValue
  }, rest), enableExpando || enableToggle ? /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: "".concat(prefix, "--table-expand__button"),
    onClick: onExpand,
    title: expandIconDescription,
    "aria-label": ariaLabel
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--table-expand__svg"),
    "aria-label": expandIconDescription
  })) : null, children);
};

TableExpandHeader.propTypes = {
  /**
   * Specify the string read by a voice reader when the expand trigger is
   * focused
   */
  ariaLabel: _propTypes.default.oneOfType([(0, _requiredIfGivenPropIsTruthy.default)('enableExpando', _propTypes.default.string), (0, _requiredIfGivenPropIsTruthy.default)('enableToggle', _propTypes.default.string)]),
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * The enableExpando prop is being replaced by enableToggle
   */
  enableExpando: (0, _deprecate.default)(_propTypes.default.bool, 'The `enableExpando` prop has been deprecated in favor of `enableToggle`. This prop will be removed in the next major release.'),

  /**
   * Specify whether an expand all button should be displayed
   */
  enableToggle: _propTypes.default.bool,

  /**
   * The description of the chevron right icon, to be put in its SVG `<title>` element.
   */
  expandIconDescription: _propTypes.default.string,

  /**
   * Specify whether this row is expanded or not. This helps coordinate data
   * attributes so that `TableExpandRow` and `TableExpandedRow` work together
   */
  isExpanded: _propTypes.default.oneOfType([(0, _requiredIfGivenPropIsTruthy.default)('enableExpando', _propTypes.default.bool), (0, _requiredIfGivenPropIsTruthy.default)('enableToggle', _propTypes.default.bool)]),

  /**
   * Hook for when a listener initiates a request to expand the given row
   */
  onExpand: _propTypes.default.oneOfType([(0, _requiredIfGivenPropIsTruthy.default)('enableExpando', _propTypes.default.func), (0, _requiredIfGivenPropIsTruthy.default)('enableToggle', _propTypes.default.func)])
};
var _default = TableExpandHeader;
exports.default = _default;