"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _Button = _interopRequireDefault(require("../Button"));

var _TableActionList = _interopRequireDefault(require("./TableActionList"));

var _Text = require("../Text");

var _excluded = ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"];
var prefix = _carbonComponents.settings.prefix;
var translationKeys = {
  'carbon.table.batch.cancel': 'Cancel',
  'carbon.table.batch.items.selected': 'items selected',
  'carbon.table.batch.item.selected': 'item selected'
};

var translateWithId = function translateWithId(id, state) {
  if (id === 'carbon.table.batch.cancel') {
    return translationKeys[id];
  }

  return "".concat(state.totalSelected, " ").concat(translationKeys[id]);
};

var TableBatchActions = function TableBatchActions(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      shouldShowBatchActions = _ref.shouldShowBatchActions,
      totalSelected = _ref.totalSelected,
      onCancel = _ref.onCancel,
      t = _ref.translateWithId,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _React$useState = _react.default.useState(),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
      isScrolling = _React$useState2[0],
      setIsScrolling = _React$useState2[1];

  var batchActionsClasses = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--batch-actions"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
  var batchSummaryClasses = (0, _classnames.default)("".concat(prefix, "--batch-summary"), (0, _defineProperty2.default)({}, "".concat(prefix, "--batch-summary__scroll"), isScrolling));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    onScroll: function onScroll() {
      setIsScrolling(!isScrolling);
    },
    "aria-hidden": !shouldShowBatchActions,
    className: batchActionsClasses
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: batchSummaryClasses
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--batch-summary__para")
  }, /*#__PURE__*/_react.default.createElement(_Text.Text, {
    as: "span"
  }, totalSelected > 1 || totalSelected === 0 ? t('carbon.table.batch.items.selected', {
    totalSelected: totalSelected
  }) : t('carbon.table.batch.item.selected', {
    totalSelected: totalSelected
  })))), /*#__PURE__*/_react.default.createElement(_TableActionList.default, null, children, /*#__PURE__*/_react.default.createElement(_Button.default, {
    className: "".concat(prefix, "--batch-summary__cancel"),
    tabIndex: shouldShowBatchActions ? 0 : -1,
    onClick: onCancel
  }, t('carbon.table.batch.cancel'))));
};

TableBatchActions.translationKeys = Object.keys(translationKeys);
TableBatchActions.propTypes = {
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * Hook required to listen for when the user initiates a cancel request
   * through this component
   */
  onCancel: _propTypes.default.func.isRequired,

  /**
   * Boolean specifier for whether or not the batch action bar should be
   * displayed
   */
  shouldShowBatchActions: _propTypes.default.bool,

  /**
   * Numeric representation of the total number of items selected in a table.
   * This number is used to derive the selection message
   */
  totalSelected: _propTypes.default.number.isRequired,

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are available on the `translationKeys` field for
   * this component.
   */
  translateWithId: _propTypes.default.func
};
TableBatchActions.defaultProps = {
  translateWithId: translateWithId
};
var _default = TableBatchActions;
exports.default = _default;