"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _getDerivedStateFromProps = _interopRequireDefault(require("./state/getDerivedStateFromProps"));

var _sorting = require("./state/sorting");

var _cells = require("./tools/cells");

var _denormalize = _interopRequireDefault(require("./tools/denormalize"));

var _events = require("../../tools/events");

var _filter = require("./tools/filter");

var _sorting2 = require("./tools/sorting");

var _instanceId = _interopRequireDefault(require("./tools/instanceId"));

var _excluded = ["header", "onClick", "isSortable"],
    _excluded2 = ["onClick"],
    _excluded3 = ["row", "onClick"],
    _excluded4 = ["onClick", "row"];

var _defaultTranslations;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var getInstanceId = (0, _instanceId.default)();
var translationKeys = {
  expandRow: 'carbon.table.row.expand',
  collapseRow: 'carbon.table.row.collapse',
  expandAll: 'carbon.table.all.expand',
  collapseAll: 'carbon.table.all.collapse',
  selectAll: 'carbon.table.all.select',
  unselectAll: 'carbon.table.all.unselect',
  selectRow: 'carbon.table.row.select',
  unselectRow: 'carbon.table.row.unselect'
};
var defaultTranslations = (_defaultTranslations = {}, (0, _defineProperty2.default)(_defaultTranslations, translationKeys.expandAll, 'Expand all rows'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.collapseAll, 'Collapse all rows'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.expandRow, 'Expand current row'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.collapseRow, 'Collapse current row'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.selectAll, 'Select all rows'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.unselectAll, 'Unselect all rows'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.selectRow, 'Select row'), (0, _defineProperty2.default)(_defaultTranslations, translationKeys.unselectRow, 'Unselect row'), _defaultTranslations);

var translateWithId = function translateWithId(id) {
  return defaultTranslations[id];
};
/**
 * Data Tables are used to represent a collection of resources, displaying a
 * subset of their fields in columns, or headers. We prioritize direct updates
 * to the state of what we're rendering, so internally we end up normalizing the
 * given data and then denormalizing it when rendering.
 *
 * As a result, each part of the DataTable is accessible through look-up by id,
 * and updating the state of the single entity will cascade updates to the
 * consumer.
 */


var DataTable = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(DataTable, _React$Component);

  var _super = _createSuper(DataTable);

  function DataTable(_props) {
    var _this;

    (0, _classCallCheck2.default)(this, DataTable);
    _this = _super.call(this, _props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getHeaderProps", function (_ref) {
      var header = _ref.header,
          _onClick = _ref.onClick,
          _ref$isSortable = _ref.isSortable,
          isSortable = _ref$isSortable === void 0 ? _this.props.isSortable : _ref$isSortable,
          rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
      var _this$state = _this.state,
          sortDirection = _this$state.sortDirection,
          sortHeaderKey = _this$state.sortHeaderKey;
      return _objectSpread(_objectSpread({}, rest), {}, {
        key: header.key,
        sortDirection: sortDirection,
        isSortable: isSortable,
        isSortHeader: sortHeaderKey === header.key,
        onClick: function onClick(event) {
          var nextSortState = (0, _sorting.getNextSortState)(_this.props, _this.state, {
            key: header.key
          });

          _this.setState(nextSortState, function () {
            _onClick && _this.handleOnHeaderClick(_onClick, {
              sortHeaderKey: header.key,
              sortDirection: nextSortState.sortDirection
            })(event);
          });
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getExpandHeaderProps", function () {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          onClick = _ref2.onClick,
          rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);

      var t = _this.props.translateWithId;
      var _this$state2 = _this.state,
          isExpandedAll = _this$state2.isExpandedAll,
          rowIds = _this$state2.rowIds,
          rowsById = _this$state2.rowsById;
      var isExpanded = isExpandedAll || rowIds.every(function (id) {
        return rowsById[id].isExpanded;
      });
      var translationKey = !isExpanded ? translationKeys.collapseAll : translationKeys.expandAll;
      return _objectSpread(_objectSpread({}, rest), {}, {
        ariaLabel: t(translationKey),
        isExpanded: isExpanded,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onExpand: (0, _events.composeEventHandlers)([_this.handleOnExpandAll, onClick ? _this.handleOnExpandHeaderClick(onClick, {
          isExpanded: isExpanded
        }) : null])
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnHeaderClick", function (onClick, sortParams) {
      return function (e) {
        return onClick(e, sortParams);
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnExpandHeaderClick", function (onClick, expandParams) {
      return function (e) {
        return onClick(e, expandParams);
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getRowProps", function (_ref3) {
      var row = _ref3.row,
          onClick = _ref3.onClick,
          rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
      var t = _this.props.translateWithId;
      var translationKey = row.isExpanded ? translationKeys.collapseRow : translationKeys.expandRow;
      return _objectSpread(_objectSpread({}, rest), {}, {
        key: row.id,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onExpand: (0, _events.composeEventHandlers)([_this.handleOnExpandRow(row.id), onClick]),
        isExpanded: row.isExpanded,
        ariaLabel: t(translationKey),
        isSelected: row.isSelected,
        disabled: row.disabled
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSelectionProps", function () {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          onClick = _ref4.onClick,
          row = _ref4.row,
          rest = (0, _objectWithoutProperties2.default)(_ref4, _excluded4);

      var t = _this.props.translateWithId; // If we're given a row, return the selection state values for that row

      if (row) {
        var _translationKey = row.isSelected ? translationKeys.unselectRow : translationKeys.selectRow;

        return _objectSpread(_objectSpread({}, rest), {}, {
          checked: row.isSelected,
          onSelect: (0, _events.composeEventHandlers)([_this.handleOnSelectRow(row.id), onClick]),
          id: "".concat(_this.getTablePrefix(), "__select-row-").concat(row.id),
          name: "select-row-".concat(row.id),
          ariaLabel: t(_translationKey),
          disabled: row.disabled,
          radio: _this.props.radio || null
        });
      } // Otherwise, we're working on `TableSelectAll` which handles toggling the
      // selection state of all rows.


      var rowCount = _this.state.rowIds.length;

      var selectedRowCount = _this.getSelectedRows().length;

      var checked = rowCount > 0 && selectedRowCount === rowCount;
      var indeterminate = rowCount > 0 && selectedRowCount > 0 && selectedRowCount !== rowCount;
      var translationKey = checked || indeterminate ? translationKeys.unselectAll : translationKeys.selectAll;
      return _objectSpread(_objectSpread({}, rest), {}, {
        ariaLabel: t(translationKey),
        checked: checked,
        id: "".concat(_this.getTablePrefix(), "__select-all"),
        indeterminate: indeterminate,
        name: 'select-all',
        onSelect: (0, _events.composeEventHandlers)([_this.handleSelectAll, onClick])
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getToolbarProps", function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var size = _this.props.size; // Remove compact, short in V11

      var isSmall = size === 'compact' || size === 'short' || size === 'xs' || size === 'sm';
      return _objectSpread(_objectSpread({}, props), {}, {
        size: isSmall ? 'small' : 'normal'
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getBatchActionProps", function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var shouldShowBatchActions = _this.state.shouldShowBatchActions;

      var totalSelected = _this.getSelectedRows().length;

      return _objectSpread(_objectSpread({}, props), {}, {
        shouldShowBatchActions: shouldShowBatchActions && totalSelected > 0,
        totalSelected: totalSelected,
        onCancel: _this.handleOnCancel
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getTableProps", function () {
      var _this$props = _this.props,
          useZebraStyles = _this$props.useZebraStyles,
          size = _this$props.size,
          isSortable = _this$props.isSortable,
          useStaticWidth = _this$props.useStaticWidth,
          shouldShowBorder = _this$props.shouldShowBorder,
          stickyHeader = _this$props.stickyHeader,
          overflowMenuOnHover = _this$props.overflowMenuOnHover;
      return {
        useZebraStyles: useZebraStyles,
        size: size,
        isSortable: isSortable,
        useStaticWidth: useStaticWidth,
        shouldShowBorder: shouldShowBorder,
        stickyHeader: stickyHeader,
        overflowMenuOnHover: overflowMenuOnHover
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getTableContainerProps", function () {
      var _this$props2 = _this.props,
          stickyHeader = _this$props2.stickyHeader,
          useStaticWidth = _this$props2.useStaticWidth;
      return {
        stickyHeader: stickyHeader,
        useStaticWidth: useStaticWidth
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSelectedRows", function () {
      return _this.state.rowIds.filter(function (id) {
        var row = _this.state.rowsById[id];
        return row.isSelected && !row.disabled;
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getFilteredRowIds", function () {
      var filteredRowIds = typeof _this.state.filterInputValue === 'string' ? _this.props.filterRows({
        rowIds: _this.state.rowIds,
        headers: _this.props.headers,
        cellsById: _this.state.cellsById,
        inputValue: _this.state.filterInputValue,
        getCellId: _cells.getCellId
      }) : _this.state.rowIds;

      if (filteredRowIds.length == 0) {
        return [];
      }

      return filteredRowIds;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getTablePrefix", function () {
      return "data-table-".concat(_this.instanceId);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setAllSelectedState", function (initialState, isSelected, filteredRowIds) {
      var rowIds = initialState.rowIds;
      return {
        rowsById: rowIds.reduce(function (acc, id) {
          return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, id, _objectSpread(_objectSpread({}, initialState.rowsById[id]), !initialState.rowsById[id].disabled && {
            isSelected: filteredRowIds.includes(id) && isSelected
          })));
        }, {})
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnCancel", function () {
      _this.setState(function (state) {
        return _objectSpread({
          shouldShowBatchActions: false
        }, _this.setAllSelectedState(state, false, _this.getFilteredRowIds()));
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSelectAll", function () {
      _this.setState(function (state) {
        var filteredRowIds = _this.getFilteredRowIds();

        var rowsById = state.rowsById;
        var isSelected = !(Object.values(rowsById).filter(function (row) {
          return row.isSelected && !row.disabled;
        }).length > 0);
        return _objectSpread({
          shouldShowBatchActions: isSelected
        }, _this.setAllSelectedState(state, isSelected, filteredRowIds));
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnSelectRow", function (rowId) {
      return function () {
        _this.setState(function (state) {
          var row = state.rowsById[rowId];

          if (_this.props.radio) {
            // deselect all radio buttons
            var rowsById = Object.entries(state.rowsById).reduce(function (p, c) {
              var _c = (0, _slicedToArray2.default)(c, 2),
                  key = _c[0],
                  val = _c[1];

              val.isSelected = false;
              p[key] = val;
              return p;
            }, {});
            return {
              shouldShowBatchActions: false,
              rowsById: _objectSpread(_objectSpread({}, rowsById), {}, (0, _defineProperty2.default)({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
                isSelected: !row.isSelected
              })))
            };
          }

          var selectedRows = state.rowIds.filter(function (id) {
            return state.rowsById[id].isSelected;
          }).length; // Predict the length of the selected rows after this change occurs

          var selectedRowsCount = !row.isSelected ? selectedRows + 1 : selectedRows - 1;
          return {
            // Basic assumption here is that we want to show the batch action bar if
            // the row is being selected. If it's being unselected, then see if we
            // have a non-zero number of selected rows that batch actions could
            // still apply to
            shouldShowBatchActions: !row.isSelected || selectedRowsCount > 0,
            rowsById: _objectSpread(_objectSpread({}, state.rowsById), {}, (0, _defineProperty2.default)({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
              isSelected: !row.isSelected
            })))
          };
        });
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnExpandRow", function (rowId) {
      return function () {
        _this.setState(function (state) {
          var row = state.rowsById[rowId];
          var isExpandedAll = state.isExpandedAll;
          return {
            isExpandedAll: row.isExpanded ? false : isExpandedAll,
            rowsById: _objectSpread(_objectSpread({}, state.rowsById), {}, (0, _defineProperty2.default)({}, rowId, _objectSpread(_objectSpread({}, row), {}, {
              isExpanded: !row.isExpanded
            })))
          };
        });
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnExpandAll", function () {
      _this.setState(function (state) {
        var rowIds = state.rowIds,
            isExpandedAll = state.isExpandedAll;
        return {
          isExpandedAll: !isExpandedAll,
          rowsById: rowIds.reduce(function (acc, id) {
            return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, id, _objectSpread(_objectSpread({}, state.rowsById[id]), {}, {
              isExpanded: !isExpandedAll
            })));
          }, {})
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSortBy", function (headerKey) {
      return function () {
        _this.setState(function (state) {
          return (0, _sorting.getNextSortState)(_this.props, state, {
            key: headerKey
          });
        });
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnInputValueChange", function (event, defaultValue) {
      if (event.target) {
        _this.setState({
          filterInputValue: event.target.value
        });
      }

      if (defaultValue) {
        _this.setState({
          filterInputValue: defaultValue
        });
      }
    });
    _this.state = _objectSpread(_objectSpread({}, (0, _getDerivedStateFromProps.default)(_props, {})), {}, {
      isExpandedAll: false // Start with collapsed state, treat `undefined` as neutral state

    });
    _this.instanceId = getInstanceId();
    return _this;
  }

  (0, _createClass2.default)(DataTable, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this2 = this;

      if (prevProps === this.props) {
        return;
      }

      var prevRowIds = prevProps.rows.map(function (row) {
        return row.id;
      });
      var rowIds = this.props.rows.map(function (row) {
        return row.id;
      });

      if (!(0, _lodash.default)(prevRowIds, rowIds)) {
        this.setState(function (state) {
          return (0, _getDerivedStateFromProps.default)(_this2.props, state);
        });
        return;
      }

      var prevHeaders = prevProps.headers.map(function (header) {
        return header.key;
      });
      var headers = this.props.headers.map(function (header) {
        return header.key;
      });

      if (!(0, _lodash.default)(prevHeaders, headers)) {
        this.setState(function (state) {
          return (0, _getDerivedStateFromProps.default)(_this2.props, state);
        });
        return;
      }

      if (!(0, _lodash.default)(prevProps.rows, this.props.rows)) {
        this.setState(function (state) {
          return (0, _getDerivedStateFromProps.default)(_this2.props, state);
        });
        return;
      }
    }
    /**
     * Get the props associated with the given header. Mostly used for adding in
     * sorting behavior.
     *
     * @param {object} config
     * @param {string} config.header the header we want the props for
     * @param {Function} config.onClick a custom click handler for the header
     * @param {boolean} config.isSortable
     * @returns {object}
     */

  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      // eslint-disable-next-line react/prop-types
      var _this$props3 = this.props,
          children = _this$props3.children,
          filterRows = _this$props3.filterRows,
          headers = _this$props3.headers,
          render = _this$props3.render;
      var _this$state3 = this.state,
          filterInputValue = _this$state3.filterInputValue,
          rowIds = _this$state3.rowIds,
          rowsById = _this$state3.rowsById,
          cellsById = _this$state3.cellsById;
      var filteredRowIds = typeof filterInputValue === 'string' ? filterRows({
        rowIds: rowIds,
        headers: headers,
        cellsById: cellsById,
        inputValue: filterInputValue,
        getCellId: _cells.getCellId
      }) : rowIds;
      var renderProps = {
        // Data derived from state
        rows: (0, _denormalize.default)(filteredRowIds, rowsById, cellsById),
        headers: this.props.headers,
        selectedRows: (0, _denormalize.default)(this.getSelectedRows(), rowsById, cellsById),
        // Prop accessors/getters
        getHeaderProps: this.getHeaderProps,
        getExpandHeaderProps: this.getExpandHeaderProps,
        getRowProps: this.getRowProps,
        getSelectionProps: this.getSelectionProps,
        getToolbarProps: this.getToolbarProps,
        getBatchActionProps: this.getBatchActionProps,
        getTableProps: this.getTableProps,
        getTableContainerProps: this.getTableContainerProps,
        // Custom event handlers
        onInputChange: this.handleOnInputValueChange,
        // Expose internal state change actions
        sortBy: function sortBy(headerKey) {
          return _this3.handleSortBy(headerKey)();
        },
        selectAll: this.handleSelectAll,
        selectRow: function selectRow(rowId) {
          return _this3.handleOnSelectRow(rowId)();
        },
        expandRow: function expandRow(rowId) {
          return _this3.handleOnExpandRow(rowId)();
        },
        expandAll: this.handleOnExpandAll,
        radio: this.props.radio
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);
  return DataTable;
}(_react.default.Component);

exports.default = DataTable;
(0, _defineProperty2.default)(DataTable, "propTypes", {
  /**
   * Optional hook to manually control filtering of the rows from the
   * TableToolbarSearch component
   */
  filterRows: _propTypes.default.func,

  /**
   * The `headers` prop represents the order in which the headers should
   * appear in the table. We expect an array of objects to be passed in, where
   * `key` is the name of the key in a row object, and `header` is the name of
   * the header.
   */
  headers: _propTypes.default.arrayOf(_propTypes.default.shape({
    key: _propTypes.default.string.isRequired,
    header: _propTypes.default.node.isRequired
  })).isRequired,

  /**
   * Specify whether the table should be able to be sorted by its headers
   */
  isSortable: _propTypes.default.bool,

  /**
   * Provide a string for the current locale
   */
  locale: _propTypes.default.string,

  /**
   * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
   */
  overflowMenuOnHover: _propTypes.default.bool,

  /**
   * Specify whether the control should be a radio button or inline checkbox
   */
  radio: _propTypes.default.bool,

  /**
   * The `rows` prop is where you provide us with a list of all the rows that
   * you want to render in the table. The only hard requirement is that this
   * is an array of objects, and that each object has a unique `id` field
   * available on it.
   */
  rows: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    disabled: _propTypes.default.bool,
    isSelected: _propTypes.default.bool,
    isExpanded: _propTypes.default.bool
  })).isRequired,

  /**
   * `false` If true, will remove the table border
   */
  shouldShowBorder: _propTypes.default.bool,

  /**
   *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
   *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
   */
  size: _propTypes.default.oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

  /**
   * Optional hook to manually control sorting of the rows.
   */
  sortRow: _propTypes.default.func,

  /**
   * Specify whether the header should be sticky.
   * Still experimental: may not work with every combination of table props
   */
  stickyHeader: _propTypes.default.bool,

  /**
   * Optional method that takes in a message id and returns an
   * internationalized string. See `DataTable.translationKeys` for all
   * available message ids.
   */
  translateWithId: _propTypes.default.func,

  /**
   * `false` If true, will use a width of 'auto' instead of 100%
   */
  useStaticWidth: _propTypes.default.bool,

  /**
   * `true` to add useZebraStyles striping.
   */
  useZebraStyles: _propTypes.default.bool
});
(0, _defineProperty2.default)(DataTable, "defaultProps", {
  sortRow: _sorting2.defaultSortRow,
  filterRows: _filter.defaultFilterRows,
  locale: 'en',
  size: 'normal',
  overflowMenuOnHover: true,
  translateWithId: translateWithId
});
(0, _defineProperty2.default)(DataTable, "translationKeys", Object.values(translationKeys));