"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Copy;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _events = require("../../tools/events");

var _excluded = ["children", "className", "feedback", "feedbackTimeout", "onAnimationEnd", "onClick"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

function Copy(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      feedback = _ref.feedback,
      feedbackTimeout = _ref.feedbackTimeout,
      onAnimationEnd = _ref.onAnimationEnd,
      onClick = _ref.onClick,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(''),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      animation = _useState2[0],
      setAnimation = _useState2[1];

  var classNames = (0, _classnames2.default)(className, "".concat(prefix, "--copy"), (_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--copy-btn--animating"), animation), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--copy-btn--").concat(animation), animation), _classnames)); // eslint-disable-next-line react-hooks/exhaustive-deps

  var handleFadeOut = (0, _react.useCallback)((0, _lodash.default)(function () {
    setAnimation('fade-out');
  }, feedbackTimeout), [feedbackTimeout]);
  var handleClick = (0, _react.useCallback)(function () {
    setAnimation('fade-in');
    handleFadeOut();
  }, [handleFadeOut]);

  var handleAnimationEnd = function handleAnimationEnd(event) {
    if (event.animationName === 'hide-feedback') {
      setAnimation('');
    }
  };

  (0, _react.useEffect)(function () {
    return function () {
      handleFadeOut.cancel();
    };
  }, [handleFadeOut]);
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    className: classNames,
    onClick: (0, _events.composeEventHandlers)([onClick, handleClick]),
    onAnimationEnd: (0, _events.composeEventHandlers)([onAnimationEnd, handleAnimationEnd])
  }, other, {
    "aria-live": "polite",
    "aria-label": !children && (animation ? feedback : other['aria-label']) || null
  }), children, animation ? feedback : other['aria-label'], /*#__PURE__*/_react.default.createElement("span", {
    "aria-hidden": "true",
    className: "".concat(prefix, "--assistive-text ").concat(prefix, "--copy-btn__feedback")
  }, feedback));
}

Copy.propTypes = {
  /**
   * Pass in content to be rendered in the underlying `<button>`
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: _propTypes.default.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: _propTypes.default.number,

  /**
   * Specify an optional `onAnimationEnd` handler that is called when the underlying
   * animation ends
   */
  onAnimationEnd: _propTypes.default.func,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: _propTypes.default.func
};
Copy.defaultProps = {
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};