"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentSwitcher = ContentSwitcher;
exports.ContentTabs = ContentTabs;
exports.ContentPanels = ContentPanels;
exports.ContentPanel = exports.ContentTab = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _keyboard = require("../../../internal/keyboard");

var _useId = require("../../../internal/useId");

var _useControllableState3 = require("../../../internal/useControllableState");

var _excluded = ["activation", "aria-label", "children", "className", "size"],
    _excluded2 = ["children"],
    _excluded3 = ["children"];
var prefix = _carbonComponents.settings.prefix; // Used to manage the overall state of the ContentSwitcher

var ContentSwitcherContext = /*#__PURE__*/_react.default.createContext(); // Used to keep track of position in a tablist


var ContentTabContext = /*#__PURE__*/_react.default.createContext(); // Used to keep track of position in a list of tab panels


var ContentPanelContext = /*#__PURE__*/_react.default.createContext();

function ContentSwitcher(_ref) {
  var children = _ref.children,
      _ref$defaultSelectedI = _ref.defaultSelectedIndex,
      defaultSelectedIndex = _ref$defaultSelectedI === void 0 ? 0 : _ref$defaultSelectedI,
      _onChange = _ref.onChange,
      controlledSelectedIndex = _ref.selectedIndex;
  var baseId = (0, _useId.useId)('ccs'); // The active index is used to track the element which has focus in our tablist

  var _React$useState = _react.default.useState(defaultSelectedIndex),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
      activeIndex = _React$useState2[0],
      setActiveIndex = _React$useState2[1]; // The selected index is used for the tab/panel pairing which is "visible"


  var _useControllableState = (0, _useControllableState3.useControllableState)({
    value: controlledSelectedIndex,
    defaultValue: defaultSelectedIndex,
    onChange: function onChange(value) {
      if (_onChange) {
        _onChange({
          selectedIndex: value
        });
      }
    }
  }),
      _useControllableState2 = (0, _slicedToArray2.default)(_useControllableState, 2),
      selectedIndex = _useControllableState2[0],
      setSelectedIndex = _useControllableState2[1];

  var value = {
    baseId: baseId,
    activeIndex: activeIndex,
    setActiveIndex: setActiveIndex,
    selectedIndex: selectedIndex,
    setSelectedIndex: setSelectedIndex
  };
  return /*#__PURE__*/_react.default.createElement(ContentSwitcherContext.Provider, {
    value: value
  }, children);
}

ContentSwitcher.propTypes = {
  /**
   * Provide child elements to be rendered inside of the `ContentSwitcher`.
   * These elements should render either `ContentTabs` or `ContentPanels`
   */
  children: _propTypes.default.node,

  /**
   * Specify which content tab should be initially selected when the component
   * is first rendered
   */
  defaultSelectedIndex: _propTypes.default.number,

  /**
   * Provide an optional function which is called whenever the state of the
   * `ContentSwitcher` changes
   */
  onChange: _propTypes.default.func,

  /**
   * Control which content panel is currently selected. This puts the component
   * in a controlled mode and should be used along with `onChange`
   */
  selectedIndex: _propTypes.default.number
};
/**
 * A `ContentPanel` corresponds to a tablist in the Tabs pattern as written in
 * WAI-ARIA Authoring Practices.
 *
 * @see https://w3c.github.io/aria-practices/#tabpanel
 */

function ContentTabs(_ref2) {
  var _ref2$activation = _ref2.activation,
      activation = _ref2$activation === void 0 ? 'automatic' : _ref2$activation,
      label = _ref2['aria-label'],
      children = _ref2.children,
      customClassName = _ref2.className,
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? 'md' : _ref2$size,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);

  var _React$useContext = _react.default.useContext(ContentSwitcherContext),
      activeIndex = _React$useContext.activeIndex,
      selectedIndex = _React$useContext.selectedIndex,
      setSelectedIndex = _React$useContext.setSelectedIndex,
      setActiveIndex = _React$useContext.setActiveIndex;

  var ref = _react.default.useRef(null);

  var className = (0, _classnames.default)(customClassName, "".concat(prefix, "--content-switcher"), (0, _defineProperty2.default)({}, "".concat(prefix, "--content-switcher--").concat(size), size));

  var count = _react.default.Children.count(children);

  var tabs = [];

  function onKeyDown(event) {
    if ((0, _keyboard.matches)(event, [_keyboard.keys.ArrowRight, _keyboard.keys.ArrowLeft, _keyboard.keys.Home, _keyboard.keys.End])) {
      var nextIndex = getNextIndex(event, count, activation === 'automatic' ? selectedIndex : activeIndex);

      if (activation === 'automatic') {
        setSelectedIndex(nextIndex);
      } else if (activation === 'manual') {
        setActiveIndex(nextIndex);
      }

      tabs[nextIndex].current.focus();
    }
  }

  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/interactive-supports-focus
    _react.default.createElement("div", (0, _extends2.default)({}, rest, {
      "aria-label": label,
      ref: ref,
      role: "tablist",
      className: className,
      onKeyDown: onKeyDown
    }), _react.default.Children.map(children, function (child, index) {
      var ref = /*#__PURE__*/_react.default.createRef();

      tabs.push(ref);
      return /*#__PURE__*/_react.default.createElement(ContentTabContext.Provider, {
        value: index
      }, /*#__PURE__*/_react.default.cloneElement(child, {
        ref: ref
      }));
    }))
  );
}

ContentTabs.propTypes = {
  /**
   * Specify whether the content tab should be activated automatically or
   * manually
   */
  activation: _propTypes.default.oneOf(['automatic', 'manual']),

  /**
   * Provide an accessible label to be read when a user interacts with this
   * component
   */
  'aria-label': _propTypes.default.string.isRequired,

  /**
   * Provide child elements to be rendered inside of `ContentTabs`.
   * These elements should render a `ContentTab`
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the size of the Content Switcher. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg'])
};
/**
 * Get the next index for a givne keyboard event given a count of the total
 * items and the current index
 * @param {Event} event
 * @param {number} total
 * @param {number} index
 * @returns {number}
 */

function getNextIndex(event, total, index) {
  if ((0, _keyboard.match)(event, _keyboard.keys.ArrowRight)) {
    return (index + 1) % total;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.ArrowLeft)) {
    return (total + index - 1) % total;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.Home)) {
    return 0;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.End)) {
    return total - 1;
  }
}

var ContentTab = /*#__PURE__*/_react.default.forwardRef(function ContentTab(_ref3, ref) {
  var children = _ref3.children,
      rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded2);

  var _React$useContext2 = _react.default.useContext(ContentSwitcherContext),
      selectedIndex = _React$useContext2.selectedIndex,
      setSelectedIndex = _React$useContext2.setSelectedIndex,
      baseId = _React$useContext2.baseId;

  var index = _react.default.useContext(ContentTabContext);

  var id = "".concat(baseId, "-tab-").concat(index);
  var panelId = "".concat(baseId, "-tabpanel-").concat(index);
  var className = (0, _classnames.default)("".concat(prefix, "--content-switcher-btn"), (0, _defineProperty2.default)({}, "".concat(prefix, "--content-switcher--selected"), selectedIndex === index));
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, {
    "aria-controls": panelId,
    "aria-selected": selectedIndex === index,
    ref: ref,
    id: id,
    role: "tab",
    className: className,
    onClick: function onClick() {
      setSelectedIndex(index);
    },
    tabIndex: selectedIndex === index ? '0' : '-1',
    type: "button"
  }), children);
});

exports.ContentTab = ContentTab;
ContentTab.propTypes = {
  /**
   * Provide child elements to be rendered inside of `ContentTab`.
   * These elements must be noninteractive
   */
  children: _propTypes.default.node
};
/**
 * Used to display all of the tab panels inside of a Content Switcher. This
 * components keeps track of position in for each ContentPanel.
 *
 * Note: children should either be a `ContentPanel` or should render a
 * `ContentPanel`. Fragments are not currently supported.
 */

function ContentPanels(_ref4) {
  var children = _ref4.children;
  return _react.default.Children.map(children, function (child, index) {
    return /*#__PURE__*/_react.default.createElement(ContentPanelContext.Provider, {
      value: index
    }, child);
  });
}

ContentPanels.propTypes = {
  /**
   * Provide child elements to be rendered inside of `ContentPanels`.
   * These elements should render a `ContentPanel`
   */
  children: _propTypes.default.node
};
/**
 * A `ContentPanel` corresponds to a tabpanel in the Tabs pattern as written in
 * WAI-ARIA Authoring Practices. This component reads the selected
 * index and base id from context in order to determine the correct `id` and
 * display status of the component.
 *
 * @see https://w3c.github.io/aria-practices/#tabpanel
 */

var ContentPanel = /*#__PURE__*/_react.default.forwardRef(function ContentPanel(props, ref) {
  var children = props.children,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded3);

  var _React$useContext3 = _react.default.useContext(ContentSwitcherContext),
      selectedIndex = _React$useContext3.selectedIndex,
      baseId = _React$useContext3.baseId;

  var index = _react.default.useContext(ContentPanelContext);

  var id = "".concat(baseId, "-tabpanel-").concat(index);
  var tabId = "".concat(baseId, "-tab-").concat(index); // TODO: tabindex should only be 0 if no interactive content in children

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    "aria-labelledby": tabId,
    id: id,
    ref: ref,
    role: "tabpanel",
    tabIndex: "0",
    hidden: selectedIndex !== index
  }), children);
});

exports.ContentPanel = ContentPanel;
ContentPanel.propTypes = {
  /**
   * Provide child elements to be rendered inside of `ContentPanel`.
   */
  children: _propTypes.default.node
};