"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "light", "selectedIndex", "selectionMode", "size"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ContentSwitcher = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(ContentSwitcher, _React$Component);

  var _super = _createSuper(ContentSwitcher);

  function ContentSwitcher() {
    var _this;

    (0, _classCallCheck2.default)(this, ContentSwitcher);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_switchRefs", []);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {});
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleItemRef", function (index) {
      return function (ref) {
        _this._switchRefs[index] = ref;
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChildChange", function (data) {
      var selectionMode = _this.props.selectionMode; // the currently selected child index

      var selectedIndex = _this.state.selectedIndex; // the newly selected child index

      var index = data.index;
      var key = data.key;

      if ((0, _keyboard.matches)(data, [_keyboard.keys.ArrowRight, _keyboard.keys.ArrowLeft])) {
        var nextIndex = (0, _keyboard.getNextIndex)(key, index, _this.props.children.length);

        var children = _react.default.Children.toArray(_this.props.children);

        if (selectionMode === 'manual') {
          var switchRef = _this._switchRefs[nextIndex];
          switchRef && switchRef.focus();
        } else {
          _this.setState({
            selectedIndex: nextIndex
          }, function () {
            var child = children[_this.state.selectedIndex];
            var switchRef = _this._switchRefs[_this.state.selectedIndex];
            switchRef && switchRef.focus();

            _this.props.onChange(_objectSpread(_objectSpread({}, data), {}, {
              index: _this.state.selectedIndex,
              name: child.props.name,
              text: child.props.text
            }));
          });
        }
      } else if (selectedIndex !== index) {
        _this.setState({
          selectedIndex: index
        }, function () {
          var switchRef = _this._switchRefs[index];
          switchRef && switchRef.focus();

          _this.props.onChange(data);
        });
      }
    });
    return _this;
  }

  (0, _createClass2.default)(ContentSwitcher, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var prefix = this.context;
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          light = _this$props.light,
          selectedIndex = _this$props.selectedIndex,
          selectionMode = _this$props.selectionMode,
          size = _this$props.size,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var classes = (0, _classnames.default)("".concat(prefix, "--content-switcher"), className, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--content-switcher--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--content-switcher--").concat(size), size), _classNames));
      return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, other, {
        className: classes,
        role: "tablist"
      }), _react.default.Children.map(children, function (child, index) {
        return /*#__PURE__*/_react.default.cloneElement(child, {
          index: index,
          onClick: (0, _events.composeEventHandlers)([_this2.handleChildChange, child.props.onClick]),
          onKeyDown: _this2.handleChildChange,
          selected: index === _this2.state.selectedIndex,
          ref: _this2.handleItemRef(index)
        });
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var selectedIndex = _ref.selectedIndex;
      var prevSelectedIndex = state.prevSelectedIndex;
      return prevSelectedIndex === selectedIndex ? null : {
        selectedIndex: selectedIndex,
        prevSelectedIndex: selectedIndex
      };
    }
  }]);
  return ContentSwitcher;
}(_react.default.Component);

exports.default = ContentSwitcher;
(0, _defineProperty2.default)(ContentSwitcher, "propTypes", {
  /**
   * Pass in Switch components to be rendered in the ContentSwitcher
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: _propTypes.default.string,

  /**
   * `true` to use the light variant.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `ContentSwitcher` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * Specify an `onChange` handler that is called whenever the ContentSwitcher
   * changes which item is selected
   */
  onChange: _propTypes.default.func.isRequired,

  /**
   * Specify a selected index for the initially selected content
   */
  selectedIndex: _propTypes.default.number,

  /**
   * Choose whether or not to automatically change selection on focus
   */
  selectionMode: _propTypes.default.oneOf(['automatic', 'manual']),

  /**
   * Specify the size of the Content Switcher. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl'])
});
(0, _defineProperty2.default)(ContentSwitcher, "contextType", _usePrefix.PrefixContext);
(0, _defineProperty2.default)(ContentSwitcher, "defaultProps", {
  selectedIndex: 0,
  selectionMode: 'automatic',
  onChange: function onChange() {}
});